/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.health;

import io.vertx.codegen.annotations.DataObject;
import java.time.Duration;

@DataObject
public class HealthServiceOptions {
    public static final Duration HEALTH_CHECK_INTERVAL = Duration.ofMillis(2500L);
    private Duration healthCheckInterval;

    public HealthServiceOptions() {
        this.healthCheckInterval = HEALTH_CHECK_INTERVAL;
    }

    public HealthServiceOptions(HealthServiceOptions other) {
        this.healthCheckInterval = other.healthCheckInterval;
    }

    public Duration getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public HealthServiceOptions setHealthCheckInterval(Duration healthCheckInterval) {
        if (healthCheckInterval == null || healthCheckInterval.toMillis() <= 0L) {
            throw new IllegalArgumentException("Health check interval must be > 0 milliseconds. Provided: " + String.valueOf(healthCheckInterval) + " milliseconds.");
        }
        this.healthCheckInterval = healthCheckInterval;
        return this;
    }
}

