/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.health.handler;

import com.google.protobuf.MessageOrBuilder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.health.handler.GrpcHealthV1HandlerBase;
import io.vertx.grpc.health.v1.HealthCheckResponse;
import io.vertx.grpc.health.v1.HealthListRequest;
import io.vertx.grpc.health.v1.HealthListResponse;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import java.util.Map;
import java.util.function.Supplier;

public class GrpcHealthListV1Handler
extends GrpcHealthV1HandlerBase
implements Handler<GrpcServerRequest<HealthListRequest, HealthListResponse>> {
    public static final ServiceMethod<HealthListRequest, HealthListResponse> SERVICE_METHOD = ServiceMethod.server((ServiceName)ServiceName.create((String)"grpc.health.v1.Health"), (String)"List", (GrpcMessageEncoder)GrpcMessageEncoder.encoder(), (GrpcMessageDecoder)GrpcMessageDecoder.decoder((MessageOrBuilder)HealthListRequest.newBuilder()));

    public GrpcHealthListV1Handler(GrpcServer server, Map<String, Supplier<Future<Boolean>>> healthChecks) {
        super(server, healthChecks);
    }

    public void handle(GrpcServerRequest<HealthListRequest, HealthListResponse> event) {
        event.handler(request -> {
            HealthListResponse.Builder builder = HealthListResponse.newBuilder();
            this.healthChecks().forEach((name, check) -> {
                HealthCheckResponse.Builder responseBuilder = HealthCheckResponse.newBuilder();
                this.checkStatus((String)name).onSuccess(result -> {
                    responseBuilder.setStatus((HealthCheckResponse.ServingStatus)((Object)((Object)((Object)result))));
                    builder.putStatuses((String)name, responseBuilder.build());
                }).onFailure(failure -> {
                    responseBuilder.setStatus(HealthCheckResponse.ServingStatus.NOT_SERVING);
                    builder.putStatuses((String)name, responseBuilder.build());
                });
            });
            event.response().end((Object)builder.build());
        });
    }
}

