/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.health.impl;

import com.google.protobuf.Descriptors;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.health.HealthService;
import io.vertx.grpc.health.HealthServiceOptions;
import io.vertx.grpc.health.handler.GrpcHealthCheckV1Handler;
import io.vertx.grpc.health.handler.GrpcHealthListV1Handler;
import io.vertx.grpc.health.handler.GrpcHealthWatchV1Handler;
import io.vertx.grpc.health.v1.HealthProto;
import io.vertx.grpc.server.GrpcServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class HealthServiceImpl
implements HealthService {
    private static final ServiceName V1_SERVICE_NAME = ServiceName.create((String)"grpc.health.v1.Health");
    private static final Descriptors.ServiceDescriptor V1_SERVICE_DESCRIPTOR = HealthProto.getDescriptor().findServiceByName("Health");
    private final Vertx vertx;
    private final HealthServiceOptions options;
    private final Map<String, Supplier<Future<Boolean>>> checks = new ConcurrentHashMap<String, Supplier<Future<Boolean>>>();

    public HealthServiceImpl(Vertx vertx) {
        this(vertx, new HealthServiceOptions());
    }

    public HealthServiceImpl(Vertx vertx, HealthServiceOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.register(V1_SERVICE_NAME, () -> Future.succeededFuture((Object)true));
    }

    public ServiceName name() {
        return V1_SERVICE_NAME;
    }

    public Descriptors.ServiceDescriptor descriptor() {
        return V1_SERVICE_DESCRIPTOR;
    }

    public void bind(GrpcServer server) {
        server.callHandler(GrpcHealthCheckV1Handler.SERVICE_METHOD, (Handler)new GrpcHealthCheckV1Handler(server, this.checks));
        server.callHandler(GrpcHealthListV1Handler.SERVICE_METHOD, (Handler)new GrpcHealthListV1Handler(server, this.checks));
        server.callHandler(GrpcHealthWatchV1Handler.SERVICE_METHOD, (Handler)new GrpcHealthWatchV1Handler(this.vertx, server, this.checks, this.options));
    }

    @Override
    public HealthService register(String name, Supplier<Future<Boolean>> check) {
        this.checks.put(name, check);
        return this;
    }

    @Override
    public HealthService unregister(String name) {
        this.checks.remove(name);
        return this;
    }

    @Override
    public Future<Boolean> checkStatus(String name) {
        Promise promise = Promise.promise();
        Supplier<Future<Boolean>> check = this.checks.get(name);
        if (check != null) {
            check.get().onComplete((Completable)promise);
        } else {
            promise.fail("Unknown service " + name);
        }
        return promise.future();
    }
}

