/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastServerID;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HazelcastAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final IMap<K, V> map;

    public HazelcastAsyncMap(Vertx vertx, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    public void get(K k, Handler<AsyncResult<V>> asyncResultHandler) {
        K kk = this.convertParam(k);
        this.vertx.executeBlocking(fut -> fut.complete(this.convertReturn(this.map.get(kk))), asyncResultHandler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> {
            this.map.put(kk, HazelcastServerID.convertServerID(vv));
            fut.complete();
        }, completionHandler);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(this.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv)))), resultHandler);
    }

    public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> {
            this.map.put(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS);
            fut.complete();
        }, completionHandler);
    }

    public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> resultHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(this.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS))), resultHandler);
    }

    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        K kk = this.convertParam(k);
        this.vertx.executeBlocking(fut -> fut.complete(this.convertReturn(this.map.remove(kk))), resultHandler);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.remove(kk, vv)), resultHandler);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(this.convertReturn(this.map.replace(kk, vv))), resultHandler);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = this.convertParam(k);
        V vv = this.convertParam(oldValue);
        V vvv = this.convertParam(newValue);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.replace(kk, vv, vvv)), resultHandler);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            this.map.clear();
            fut.complete();
        }, resultHandler);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.size()), resultHandler);
    }

    private <T> T convertParam(T obj) {
        if (obj instanceof ClusterSerializable) {
            ClusterSerializable cobj = (ClusterSerializable)obj;
            return (T)new DataSerializableHolder(cobj);
        }
        return obj;
    }

    private <T> T convertReturn(Object obj) {
        if (obj instanceof DataSerializableHolder) {
            DataSerializableHolder cobj = (DataSerializableHolder)obj;
            return (T)cobj.clusterSerializable();
        }
        return (T)obj;
    }

    private static final class DataSerializableHolder
    implements DataSerializable {
        private ClusterSerializable clusterSerializable;

        public DataSerializableHolder() {
        }

        private DataSerializableHolder(ClusterSerializable clusterSerializable) {
            this.clusterSerializable = clusterSerializable;
        }

        public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
            objectDataOutput.writeUTF(this.clusterSerializable.getClass().getName());
            Buffer buffer = Buffer.buffer();
            this.clusterSerializable.writeToBuffer(buffer);
            byte[] bytes = buffer.getBytes();
            objectDataOutput.writeInt(bytes.length);
            objectDataOutput.write(bytes);
        }

        public void readData(ObjectDataInput objectDataInput) throws IOException {
            String className = objectDataInput.readUTF();
            int length = objectDataInput.readInt();
            byte[] bytes = new byte[length];
            objectDataInput.readFully(bytes);
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                this.clusterSerializable = (ClusterSerializable)clazz.newInstance();
                this.clusterSerializable.readFromBuffer(0, Buffer.buffer((byte[])bytes));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load class " + e.getMessage(), e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataSerializableHolder)) {
                return false;
            }
            DataSerializableHolder that = (DataSerializableHolder)o;
            return !(this.clusterSerializable != null ? !this.clusterSerializable.equals(that.clusterSerializable) : that.clusterSerializable != null);
        }

        public int hashCode() {
            return this.clusterSerializable != null ? this.clusterSerializable.hashCode() : 0;
        }

        public ClusterSerializable clusterSerializable() {
            return this.clusterSerializable;
        }
    }
}

