/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.spi.cluster.hazelcast.impl.ChoosableSet;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastClusterNodeInfo;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class HazelcastAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V>,
EntryListener<K, V> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastAsyncMultiMap.class);
    private final VertxInternal vertx;
    private final MultiMap<K, V> map;
    private final AtomicInteger getInProgressCount = new AtomicInteger();
    private final TaskQueue taskQueue = new TaskQueue();
    private ConcurrentMap<K, ChoosableSet<V>> cache = new ConcurrentHashMap<K, ChoosableSet<V>>();

    public HazelcastAsyncMultiMap(Vertx vertx, MultiMap<K, V> map) {
        this.vertx = (VertxInternal)vertx;
        this.map = map;
        map.addEntryListener((EntryListener)this, true);
    }

    public void removeAllForValue(V val, Handler<AsyncResult<Void>> completionHandler) {
        this.removeAllMatching(val::equals, completionHandler);
    }

    public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> {
            for (Map.Entry entry : this.map.entrySet()) {
                Object v = entry.getValue();
                if (!p.test(v)) continue;
                this.map.remove(entry.getKey(), v);
            }
            fut.complete();
        }, this.taskQueue, completionHandler);
    }

    public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> {
            this.map.put(k, HazelcastClusterNodeInfo.convertClusterNodeInfo(v));
            fut.complete();
        }, this.taskQueue, completionHandler);
    }

    public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> resultHandler) {
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null && entries.isInitialised() && this.getInProgressCount.get() == 0) {
            resultHandler.handle((Object)Future.succeededFuture((Object)entries));
        } else {
            this.getInProgressCount.incrementAndGet();
            this.vertx.getOrCreateContext().executeBlocking(fut -> {
                ChoosableSet prev;
                ChoosableSet sids;
                Collection entries2 = this.map.get(k);
                if (entries2 != null) {
                    sids = new ChoosableSet(entries2.size());
                    for (Object hid : entries2) {
                        sids.add(hid);
                    }
                } else {
                    sids = new ChoosableSet(0);
                }
                ChoosableSet choosableSet = prev = sids.isEmpty() ? null : this.cache.putIfAbsent(k, sids);
                if (prev != null) {
                    prev.merge(sids);
                    sids = prev;
                }
                sids.setInitialised();
                fut.complete(sids);
            }, this.taskQueue, res -> {
                this.getInProgressCount.decrementAndGet();
                resultHandler.handle(res);
            });
        }
    }

    public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> fut.complete((Object)this.map.remove(k, HazelcastClusterNodeInfo.convertClusterNodeInfo(v))), this.taskQueue, completionHandler);
    }

    public void entryAdded(EntryEvent<K, V> entry) {
        this.addEntry(entry.getKey(), entry.getValue());
    }

    private void addEntry(K k, V v) {
        ChoosableSet prev;
        ChoosableSet<V> entries = (ChoosableSet<V>)this.cache.get(k);
        if (entries == null && (prev = this.cache.putIfAbsent(k, entries = new ChoosableSet<V>(1))) != null) {
            entries = prev;
        }
        entries.add(v);
    }

    public void entryRemoved(EntryEvent<K, V> entry) {
        this.removeEntry(entry.getKey(), entry.getOldValue());
    }

    private void removeEntry(K k, V v) {
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null && v != null) {
            entries.remove(v);
            if (entries.isEmpty()) {
                this.cache.remove(k);
            }
        }
    }

    public void entryUpdated(EntryEvent<K, V> entry) {
        Object k = entry.getKey();
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null) {
            entries.add(entry.getValue());
        }
    }

    public void entryEvicted(EntryEvent<K, V> entry) {
        this.entryRemoved(entry);
    }

    public void mapEvicted(MapEvent mapEvent) {
        this.clearCache();
    }

    public void mapCleared(MapEvent mapEvent) {
        this.clearCache();
    }

    public void clearCache() {
        this.cache.clear();
    }
}

