/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMultiMap;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastInternalAsyncCounter;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastInternalAsyncMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class HazelcastClusterManager
implements ClusterManager,
MembershipListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String LOCK_SEMAPHORE_PREFIX = "__vertx.";
    private static final String NODE_ID_ATTRIBUTE = "__vertx.nodeId";
    private static final String DEFAULT_CONFIG_FILE = "default-cluster.xml";
    private static final String CONFIG_FILE = "cluster.xml";
    private static final String OPTION_USE_HZ_ASYNC_API = "vertx.hazelcast.async-api";
    private static final boolean USE_HZ_ASYNC_API = Boolean.getBoolean("vertx.hazelcast.async-api");
    private Vertx vertx;
    private HazelcastInstance hazelcast;
    private String nodeID;
    private String membershipListenerId;
    private String lifecycleListenerId;
    private boolean customHazelcastCluster;
    private Set<String> nodeIds = new HashSet<String>();
    private Set<HazelcastAsyncMultiMap> multimaps = Collections.newSetFromMap(new WeakHashMap(1));
    private NodeListener nodeListener;
    private volatile boolean active;
    private Config conf;

    public HazelcastClusterManager() {
    }

    public HazelcastClusterManager(Config conf) {
        Objects.requireNonNull(conf, "The Hazelcast config cannot be null.");
        this.conf = conf;
    }

    public HazelcastClusterManager(HazelcastInstance instance) {
        Objects.requireNonNull(instance, "The Hazelcast instance cannot be null.");
        this.hazelcast = instance;
        this.customHazelcastCluster = true;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public synchronized void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            if (!this.active) {
                this.active = true;
                if (!this.customHazelcastCluster) {
                    if (this.conf == null) {
                        this.conf = this.loadConfig();
                        if (this.conf == null) {
                            log.warn((Object)"Cannot find cluster configuration on 'vertx.hazelcast.config' system property, on the classpath, or specified programmatically. Using default hazelcast configuration");
                            this.conf = new Config();
                        }
                    }
                    this.conf.setProperty("hazelcast.shutdownhook.enabled", "false");
                    this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.conf);
                }
                Member localMember = this.hazelcast.getCluster().getLocalMember();
                this.nodeID = localMember.getUuid();
                localMember.setStringAttribute(NODE_ID_ATTRIBUTE, this.nodeID);
                this.membershipListenerId = this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
                this.lifecycleListenerId = this.hazelcast.getLifecycleService().addLifecycleListener((LifecycleListener)this);
                fut.complete();
            }
        }, resultHandler);
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            MultiMap multiMap = this.hazelcast.getMultiMap(name);
            HazelcastAsyncMultiMap asyncMultiMap = new HazelcastAsyncMultiMap(this.vertx, multiMap);
            HazelcastClusterManager hazelcastClusterManager = this;
            synchronized (hazelcastClusterManager) {
                this.multimaps.add(asyncMultiMap);
            }
            fut.complete(asyncMultiMap);
        }, resultHandler);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public List<String> getNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Member member : this.hazelcast.getCluster().getMembers()) {
            String nodeIdAttribute = member.getStringAttribute(NODE_ID_ATTRIBUTE);
            list.add(nodeIdAttribute != null ? nodeIdAttribute : member.getUuid());
        }
        return list;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            IMap map = this.hazelcast.getMap(name);
            fut.complete(USE_HZ_ASYNC_API ? new HazelcastInternalAsyncMap(this.vertx, map) : new HazelcastAsyncMap(this.vertx, map));
        }, resultHandler);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        IMap map = this.hazelcast.getMap(name);
        return map;
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        ContextImpl context = (ContextImpl)this.vertx.getOrCreateContext();
        context.executeBlocking(() -> {
            long start;
            ISemaphore iSemaphore = this.hazelcast.getSemaphore(LOCK_SEMAPHORE_PREFIX + name);
            boolean locked = false;
            long remaining = timeout;
            do {
                start = System.nanoTime();
                try {
                    locked = iSemaphore.tryAcquire(remaining, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!locked && (remaining -= TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)) > 0L);
            if (locked) {
                return new HazelcastLock(iSemaphore);
            }
            throw new VertxException("Timed out waiting to get lock " + name);
        }, resultHandler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        this.vertx.executeBlocking(fut -> fut.complete(USE_HZ_ASYNC_API ? new HazelcastInternalAsyncCounter(this.vertx, this.hazelcast.getAtomicLong(name)) : new HazelcastCounter(this.hazelcast.getAtomicLong(name))), resultHandler);
    }

    public void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            HazelcastClusterManager hazelcastClusterManager = this;
            synchronized (hazelcastClusterManager) {
                if (this.active) {
                    try {
                        this.active = false;
                        boolean left = this.hazelcast.getCluster().removeMembershipListener(this.membershipListenerId);
                        if (!left) {
                            log.warn((Object)"No membership listener");
                        }
                        this.hazelcast.getLifecycleService().removeLifecycleListener(this.lifecycleListenerId);
                        while (!this.customHazelcastCluster && this.hazelcast.getLifecycleService().isRunning()) {
                            try {
                                this.hazelcast.getLifecycleService().shutdown();
                            }
                            catch (RejectedExecutionException ignore) {
                                log.debug((Object)"Rejected execution of the shutdown operation, retrying");
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException t) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (this.customHazelcastCluster) {
                            this.hazelcast.getCluster().getLocalMember().removeAttribute(NODE_ID_ATTRIBUTE);
                        }
                    }
                    catch (Throwable t) {
                        fut.fail(t);
                    }
                }
            }
            fut.complete();
        }, resultHandler);
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String memberNodeId = member.getStringAttribute(NODE_ID_ATTRIBUTE);
        if (memberNodeId == null) {
            memberNodeId = member.getUuid();
        }
        try {
            this.multimaps.forEach(HazelcastAsyncMultiMap::clearCache);
            if (this.nodeListener != null) {
                this.nodeIds.add(memberNodeId);
                this.nodeListener.nodeAdded(memberNodeId);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberAdded", t);
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String memberNodeId = member.getStringAttribute(NODE_ID_ATTRIBUTE);
        if (memberNodeId == null) {
            memberNodeId = member.getUuid();
        }
        try {
            this.multimaps.forEach(HazelcastAsyncMultiMap::clearCache);
            if (this.nodeListener != null) {
                this.nodeIds.remove(memberNodeId);
                this.nodeListener.nodeLeft(memberNodeId);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberRemoved", t);
        }
    }

    public synchronized void stateChanged(LifecycleEvent lifecycleEvent) {
        if (!this.active) {
            return;
        }
        this.multimaps.forEach(HazelcastAsyncMultiMap::clearCache);
        if (lifecycleEvent.getState() == LifecycleEvent.LifecycleState.MERGED) {
            List<String> currentNodes = this.getNodes();
            HashSet<String> newNodes = new HashSet<String>(currentNodes);
            newNodes.removeAll(this.nodeIds);
            HashSet<String> removedMembers = new HashSet<String>(this.nodeIds);
            removedMembers.removeAll(currentNodes);
            for (String nodeId : newNodes) {
                this.nodeListener.nodeAdded(nodeId);
            }
            for (String nodeId : removedMembers) {
                this.nodeListener.nodeLeft(nodeId);
            }
            this.nodeIds.retainAll(currentNodes);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private InputStream getConfigStream() {
        InputStream is = this.getConfigStreamFromSystemProperty();
        if (is == null) {
            is = this.getConfigStreamFromClasspath(CONFIG_FILE, DEFAULT_CONFIG_FILE);
        }
        return is;
    }

    private InputStream getConfigStreamFromSystemProperty() {
        String configProp = System.getProperty("vertx.hazelcast.config");
        FileInputStream is = null;
        if (configProp != null) {
            if (configProp.startsWith("classpath:")) {
                return this.getConfigStreamFromClasspath(configProp.substring("classpath:".length()), CONFIG_FILE);
            }
            File cfgFile = new File(configProp);
            if (cfgFile.exists()) {
                try {
                    is = new FileInputStream(cfgFile);
                }
                catch (FileNotFoundException ex) {
                    log.warn((Object)("Failed to open file '" + configProp + "' defined in 'vertx.hazelcast.config'. Continuing classpath search for " + CONFIG_FILE));
                }
            }
        }
        return is;
    }

    private InputStream getConfigStreamFromClasspath(String configFile, String defaultConfig) {
        InputStream is = null;
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        if (ctxClsLoader != null) {
            is = ctxClsLoader.getResourceAsStream(configFile);
        }
        if (is == null && (is = this.getClass().getClassLoader().getResourceAsStream(configFile)) == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(defaultConfig);
        }
        return is;
    }

    public Config getConfig() {
        return this.conf;
    }

    public void setConfig(Config config) {
        this.conf = config;
    }

    public Config loadConfig() {
        Config cfg = null;
        try (InputStream is = this.getConfigStream();
             BufferedInputStream bis = new BufferedInputStream(is);){
            cfg = new XmlConfigBuilder((InputStream)bis).build();
        }
        catch (IOException ex) {
            log.error((Object)"Failed to read config", (Throwable)ex);
        }
        return cfg;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcast;
    }

    private class HazelcastLock
    implements Lock {
        private final ISemaphore semaphore;

        private HazelcastLock(ISemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void release() {
            HazelcastClusterManager.this.vertx.executeBlocking(future -> {
                this.semaphore.release();
                future.complete();
            }, false, null);
        }
    }

    private class HazelcastCounter
    implements Counter {
        private IAtomicLong atomicLong;

        private HazelcastCounter(IAtomicLong atomicLong) {
            this.atomicLong = atomicLong;
        }

        public void get(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.get()), resultHandler);
        }

        public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.incrementAndGet()), resultHandler);
        }

        public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.getAndIncrement()), resultHandler);
        }

        public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.decrementAndGet()), resultHandler);
        }

        public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.addAndGet(value)), resultHandler);
        }

        public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.getAndAdd(value)), resultHandler);
        }

        public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.compareAndSet(expected, value)), resultHandler);
        }
    }
}

