/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.spi.cluster.hazelcast.impl.ChoosableSet;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastClusterNodeInfo;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class HazelcastAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V>,
EntryListener<K, V> {
    private final VertxInternal vertx;
    private final MultiMap<K, V> map;
    private final TaskQueue taskQueue = new TaskQueue();
    private ConcurrentMap<K, ChoosableSet<V>> cache = new ConcurrentHashMap<K, ChoosableSet<V>>();

    public HazelcastAsyncMultiMap(Vertx vertx, MultiMap<K, V> map) {
        this.vertx = (VertxInternal)vertx;
        this.map = map;
        map.addEntryListener((EntryListener)this, true);
    }

    public void removeAllForValue(V val, Handler<AsyncResult<Void>> completionHandler) {
        this.removeAllMatching(val::equals, completionHandler);
    }

    public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> {
            for (Map.Entry entry : this.map.entrySet()) {
                Object v = entry.getValue();
                if (!p.test(v)) continue;
                this.map.remove(entry.getKey(), v);
            }
            fut.complete();
        }, this.taskQueue, completionHandler);
    }

    public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> {
            this.map.put(k, HazelcastClusterNodeInfo.convertClusterNodeInfo(v));
            fut.complete();
        }, this.taskQueue, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> resultHandler) {
        Queue getRequests;
        ContextImpl context = this.vertx.getOrCreateContext();
        Queue queue = getRequests = (Queue)context.contextData().computeIfAbsent(this, ctx -> new ArrayDeque());
        synchronized (queue) {
            ChoosableSet entries = (ChoosableSet)this.cache.get(k);
            if (entries != null && entries.isInitialised() && getRequests.isEmpty()) {
                context.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)entries)));
            } else {
                getRequests.add(new GetRequest<K, V>(k, resultHandler));
                if (getRequests.size() == 1) {
                    this.dequeueGet(context, getRequests);
                }
            }
        }
    }

    private void dequeueGet(ContextImpl context, Queue<GetRequest<K, V>> getRequests) {
        Handler handler;
        GetRequest<K, V> getRequest;
        block1: {
            do {
                getRequest = getRequests.peek();
                ChoosableSet entries = (ChoosableSet)this.cache.get(getRequest.key);
                if (entries == null || !entries.isInitialised()) break block1;
                handler = getRequest.handler;
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)entries)));
                getRequests.remove();
            } while (!getRequests.isEmpty());
            return;
        }
        Object key = getRequest.key;
        handler = getRequest.handler;
        context.executeBlocking(fut -> {
            ChoosableSet prev;
            ChoosableSet sids;
            Collection entries = this.map.get(key);
            if (entries != null) {
                sids = new ChoosableSet(entries.size());
                for (Object hid : entries) {
                    sids.add(hid);
                }
            } else {
                sids = new ChoosableSet(0);
            }
            ChoosableSet choosableSet = prev = sids.isEmpty() ? null : this.cache.putIfAbsent(key, sids);
            if (prev != null) {
                prev.merge(sids);
                sids = prev;
            }
            sids.setInitialised();
            fut.complete(sids);
        }, this.taskQueue, res -> {
            Queue queue = getRequests;
            synchronized (queue) {
                context.runOnContext(v -> handler.handle(res));
                getRequests.remove();
                if (!getRequests.isEmpty()) {
                    this.dequeueGet(context, getRequests);
                }
            }
        });
    }

    public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> fut.complete((Object)this.map.remove(k, HazelcastClusterNodeInfo.convertClusterNodeInfo(v))), this.taskQueue, completionHandler);
    }

    public void entryAdded(EntryEvent<K, V> entry) {
        this.addEntry(entry.getKey(), entry.getValue());
    }

    private void addEntry(K k, V v) {
        ChoosableSet prev;
        ChoosableSet<V> entries = (ChoosableSet<V>)this.cache.get(k);
        if (entries == null && (prev = this.cache.putIfAbsent(k, entries = new ChoosableSet<V>(1))) != null) {
            entries = prev;
        }
        entries.add(v);
    }

    public void entryRemoved(EntryEvent<K, V> entry) {
        this.removeEntry(entry.getKey(), entry.getOldValue());
    }

    private void removeEntry(K k, V v) {
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null && v != null) {
            entries.remove(v);
            if (entries.isEmpty()) {
                this.cache.remove(k);
            }
        }
    }

    public void entryUpdated(EntryEvent<K, V> entry) {
        Object k = entry.getKey();
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null) {
            entries.add(entry.getValue());
        }
    }

    public void entryEvicted(EntryEvent<K, V> entry) {
        this.entryRemoved(entry);
    }

    public void mapEvicted(MapEvent mapEvent) {
        this.clearCache();
    }

    public void mapCleared(MapEvent mapEvent) {
        this.clearCache();
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static class GetRequest<K, V> {
        final K key;
        final Handler<AsyncResult<ChoosableIterable<V>>> handler;

        GetRequest(K key, Handler<AsyncResult<ChoosableIterable<V>>> handler) {
            this.key = key;
            this.handler = handler;
        }
    }
}

