/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import io.vertx.core.eventbus.impl.clustered.ClusterNodeInfo;
import io.vertx.core.net.impl.ServerID;
import java.io.IOException;

public class HazelcastClusterNodeInfo
extends ClusterNodeInfo
implements DataSerializable {
    public HazelcastClusterNodeInfo() {
    }

    public HazelcastClusterNodeInfo(ClusterNodeInfo clusterNodeInfo) {
        super(clusterNodeInfo.nodeId, clusterNodeInfo.serverID);
    }

    public void writeData(ObjectDataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.nodeId);
        dataOutput.writeInt(this.serverID.port);
        dataOutput.writeUTF(this.serverID.host);
    }

    public void readData(ObjectDataInput dataInput) throws IOException {
        this.nodeId = dataInput.readUTF();
        this.serverID = new ServerID(dataInput.readInt(), dataInput.readUTF());
    }

    public static <V> V convertClusterNodeInfo(V val) {
        if (val.getClass() == ClusterNodeInfo.class) {
            ClusterNodeInfo cni = (ClusterNodeInfo)val;
            HazelcastClusterNodeInfo hcni = new HazelcastClusterNodeInfo(cni);
            return (V)((Object)hcni);
        }
        return val;
    }
}

