/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String DEFAULT_CONFIG_FILE = "default-cluster.xml";
    private static final String CONFIG_FILE = "cluster.xml";

    public static Config loadConfig() {
        Config cfg = null;
        try (InputStream is = ConfigUtil.getConfigStream();
             BufferedInputStream bis = new BufferedInputStream(is);){
            cfg = new XmlConfigBuilder((InputStream)bis).build();
        }
        catch (IOException ex) {
            log.error((Object)"Failed to read config", (Throwable)ex);
        }
        return cfg;
    }

    private static InputStream getConfigStream() {
        InputStream is = ConfigUtil.getConfigStreamFromSystemProperty();
        if (is == null) {
            is = ConfigUtil.getConfigStreamFromClasspath(CONFIG_FILE, DEFAULT_CONFIG_FILE);
        }
        return is;
    }

    private static InputStream getConfigStreamFromSystemProperty() {
        String configProp = System.getProperty("vertx.hazelcast.config");
        FileInputStream is = null;
        if (configProp != null) {
            if (configProp.startsWith("classpath:")) {
                return ConfigUtil.getConfigStreamFromClasspath(configProp.substring("classpath:".length()), CONFIG_FILE);
            }
            File cfgFile = new File(configProp);
            if (cfgFile.exists()) {
                try {
                    is = new FileInputStream(cfgFile);
                }
                catch (FileNotFoundException ex) {
                    log.warn((Object)("Failed to open file '" + configProp + "' defined in 'vertx.hazelcast.config'. Continuing classpath search for " + CONFIG_FILE));
                }
            }
        }
        return is;
    }

    private static InputStream getConfigStreamFromClasspath(String configFile, String defaultConfig) {
        InputStream is = null;
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        if (ctxClsLoader != null) {
            is = ctxClsLoader.getResourceAsStream(configFile);
        }
        if (is == null && (is = ConfigUtil.class.getClassLoader().getResourceAsStream(configFile)) == null) {
            is = ConfigUtil.class.getClassLoader().getResourceAsStream(defaultConfig);
        }
        return is;
    }

    private ConfigUtil() {
    }
}

