/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.cp.IAtomicLong;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.Counter;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class HazelcastCounter
implements Counter {
    private final VertxInternal vertx;
    private final IAtomicLong atomicLong;

    public HazelcastCounter(VertxInternal vertx, IAtomicLong atomicLong) {
        this.vertx = vertx;
        this.atomicLong = atomicLong;
    }

    public Future<Long> get() {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.getAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> incrementAndGet() {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.incrementAndGetAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> getAndIncrement() {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.getAndIncrementAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> decrementAndGet() {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.decrementAndGetAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> addAndGet(long value) {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.addAndGetAsync(value), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> getAndAdd(long value) {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.getAndAddAsync(value), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> compareAndSet(long expected, long value) {
        return Future.fromCompletionStage((CompletionStage)this.atomicLong.compareAndSetAsync(expected, value), (Context)this.vertx.getOrCreateContext());
    }

    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.get().onComplete(resultHandler);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.incrementAndGet().onComplete(resultHandler);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAndIncrement().onComplete(resultHandler);
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.decrementAndGet().onComplete(resultHandler);
    }

    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(value).onComplete(resultHandler);
    }

    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAndAdd(value).onComplete(resultHandler);
    }

    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.compareAndSet(expected, value).onComplete(resultHandler);
    }
}

