/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import com.hazelcast.core.HazelcastInstance;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.WrappedClusterManager;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);

    public static void closeClustered(List<Vertx> clustered) throws Exception {
        for (Vertx vertx : clustered) {
            VertxInternal vertxInternal = (VertxInternal)vertx;
            HazelcastClusterManager clusterManager = Lifecycle.getHazelcastClusterManager(vertxInternal.getClusterManager());
            if (clusterManager != null) {
                HazelcastInstance hazelcastInstance = clusterManager.getHazelcastInstance();
                TimeUnit.SECONDS.sleep(2L);
                long start = System.currentTimeMillis();
                try {
                    while (!hazelcastInstance.getPartitionService().isClusterSafe() && System.currentTimeMillis() - start < TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES)) {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CountDownLatch latch = new CountDownLatch(1);
            vertxInternal.close(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to shutdown vert.x", ar.cause());
                }
                latch.countDown();
            });
            latch.await(2L, TimeUnit.MINUTES);
        }
    }

    private static HazelcastClusterManager getHazelcastClusterManager(ClusterManager cm) {
        if (cm == null) {
            return null;
        }
        if (cm instanceof WrappedClusterManager) {
            return Lifecycle.getHazelcastClusterManager(((WrappedClusterManager)cm).getDelegate());
        }
        if (cm instanceof HazelcastClusterManager) {
            return (HazelcastClusterManager)cm;
        }
        throw new ClassCastException("Unexpected cluster manager implementation: " + cm.getClass());
    }

    public static void closeDataNodes(List<HazelcastInstance> dataNodes) throws Exception {
        for (HazelcastInstance dataNode : dataNodes) {
            dataNode.getLifecycleService().terminate();
        }
    }

    private Lifecycle() {
    }
}

