/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import io.vertx.LoggingTestWatcher;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import io.vertx.test.core.AsyncTestBase;
import java.math.BigInteger;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;

public class ProgrammaticHazelcastClusterManagerTest
extends AsyncTestBase {
    @Rule
    public LoggingTestWatcher watchman = new LoggingTestWatcher();

    public void setUp() throws Exception {
        Random random = new Random();
        System.setProperty("vertx.hazelcast.test.group.name", new BigInteger(128, random).toString(32));
        super.setUp();
    }

    @Test
    public void testProgrammaticSetConfig() throws Exception {
        Config config = this.createConfig();
        HazelcastClusterManager mgr = new HazelcastClusterManager();
        mgr.setConfig(config);
        this.testProgrammatic(mgr, config);
    }

    @Test
    public void testProgrammaticSetWithConstructor() throws Exception {
        Config config = this.createConfig();
        HazelcastClusterManager mgr = new HazelcastClusterManager(config);
        this.testProgrammatic(mgr, config);
    }

    @Test
    public void testCustomHazelcastInstance() throws Exception {
        HazelcastInstance instance = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        HazelcastClusterManager mgr = new HazelcastClusterManager(instance);
        this.testProgrammatic(mgr, instance.getConfig());
    }

    private Config createConfig() {
        Config config = new Config().setProperty("hazelcast.wait.seconds.before.join", "0").setProperty("hazelcast.local.localAddress", "127.0.0.1").setClusterName(System.getProperty("vertx.hazelcast.test.group.name"));
        config.getMemberAttributeConfig().setAttribute("__vertx.nodeId", UUID.randomUUID().toString());
        return config;
    }

    private void testProgrammatic(HazelcastClusterManager mgr, Config config) throws Exception {
        mgr.setConfig(config);
        this.assertEquals(config, mgr.getConfig());
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)mgr);
        Vertx.clusteredVertx((VertxOptions)options, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr.getHazelcastInstance());
            ((Vertx)res.result()).close(res2 -> {
                this.assertTrue(res2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testEventBusWhenUsingACustomHazelcastInstance() throws Exception {
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        HazelcastClusterManager mgr1 = new HazelcastClusterManager(instance1);
        HazelcastClusterManager mgr2 = new HazelcastClusterManager(instance2);
        VertxOptions options1 = new VertxOptions().setClusterManager((ClusterManager)mgr1);
        options1.getEventBusOptions().setHost("127.0.0.1");
        VertxOptions options2 = new VertxOptions().setClusterManager((ClusterManager)mgr2);
        options2.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        AtomicReference vertx2 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options1, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr1.getHazelcastInstance());
            ((Vertx)res.result()).eventBus().consumer("news", message -> {
                this.assertNotNull(message);
                this.assertTrue(message.body().equals("hello"));
                this.testComplete();
            });
            vertx1.set(res.result());
        });
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        Vertx.clusteredVertx((VertxOptions)options2, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr2.getHazelcastInstance());
            vertx2.set(res.result());
            ((Vertx)res.result()).eventBus().send("news", (Object)"hello");
        });
        this.await();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ((Vertx)vertx2.get()).close(ar -> vertx2.set(null));
        this.assertTrue(instance1.getLifecycleService().isRunning());
        this.assertTrue(instance2.getLifecycleService().isRunning());
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null && vertx2.get() == null);
        instance1.shutdown();
        instance2.shutdown();
    }

    @Test
    public void testSharedDataUsingCustomHazelcast() throws Exception {
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        HazelcastClusterManager mgr1 = new HazelcastClusterManager(instance1);
        HazelcastClusterManager mgr2 = new HazelcastClusterManager(instance2);
        VertxOptions options1 = new VertxOptions().setClusterManager((ClusterManager)mgr1);
        options1.getEventBusOptions().setHost("127.0.0.1");
        VertxOptions options2 = new VertxOptions().setClusterManager((ClusterManager)mgr2);
        options2.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        AtomicReference vertx2 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options1, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr1.getHazelcastInstance());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).put((Object)"news", (Object)"hello", v -> vertx1.set(res.result())));
        });
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        Vertx.clusteredVertx((VertxOptions)options2, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr2.getHazelcastInstance());
            vertx2.set(res.result());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).get((Object)"news", r -> {
                this.assertEquals("hello", r.result());
                this.testComplete();
            }));
        });
        this.await();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ((Vertx)vertx2.get()).close(ar -> vertx2.set(null));
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null && vertx2.get() == null);
        this.assertTrue(instance1.getLifecycleService().isRunning());
        this.assertTrue(instance2.getLifecycleService().isRunning());
        instance1.shutdown();
        instance2.shutdown();
    }

    @Test
    public void testThatExternalHZInstanceCanBeShutdown() {
        HazelcastInstance instance = Hazelcast.newHazelcastInstance((Config)this.createConfig());
        String nodeID = instance.getCluster().getLocalMember().getAttribute("__vertx.nodeId");
        HazelcastClusterManager mgr = new HazelcastClusterManager(this.createConfig());
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)mgr);
        options.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr.getHazelcastInstance());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).put((Object)"news", (Object)"hello", v -> vertx1.set(res.result())));
        });
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        int size = mgr.getNodes().size();
        this.assertTrue(mgr.getNodes().contains(nodeID));
        IMap map = instance.getMap("mymap1");
        IMap anotherMap = instance.getMap("mymap2");
        this.assertEquals(map.get("news"), "hello");
        map.put("another-key", "stuff");
        anotherMap.put("another-key", "stuff");
        map.remove("news");
        map.remove("another-key");
        anotherMap.remove("another-key");
        instance.shutdown();
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> mgr.getNodes().size() == size - 1);
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ProgrammaticHazelcastClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null);
    }

    @AfterClass
    public static void afterTests() {
        System.clearProperty("hazelcast.client.max.no.heartbeat.seconds");
    }

    static {
        System.setProperty("hazelcast.client.max.no.heartbeat.seconds", "9");
    }
}

