/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.litemembers;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import io.vertx.Lifecycle;
import io.vertx.LoggingTestWatcher;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.ClusteredEventBusTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.hazelcast.ConfigUtil;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Rule;

public class HazelcastClusteredEventbusTest
extends ClusteredEventBusTest {
    private static final int DATA_NODES = Integer.getInteger("litemembers.datanodes.count", 1);
    @Rule
    public LoggingTestWatcher watchman = new LoggingTestWatcher();
    private List<HazelcastInstance> dataNodes = new ArrayList<HazelcastInstance>();

    public void setUp() throws Exception {
        Random random = new Random();
        System.setProperty("vertx.hazelcast.test.group.name", new BigInteger(128, random).toString(32));
        for (int i = 0; i < DATA_NODES; ++i) {
            this.dataNodes.add(Hazelcast.newHazelcastInstance((Config)ConfigUtil.loadConfig()));
        }
        super.setUp();
    }

    protected ClusterManager getClusterManager() {
        return new HazelcastClusterManager(ConfigUtil.loadConfig().setLiteMember(true));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Lifecycle.closeDataNodes(this.dataNodes);
    }

    protected void close(List<Vertx> clustered) throws Exception {
        Lifecycle.closeClustered(clustered);
    }
}

