/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.LoggingTestWatcher;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.impl.DiscoveryImplTestBase;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.math.BigInteger;
import java.util.Random;
import org.junit.Before;
import org.junit.Rule;

public class HazelcastDiscoveryImplClusteredTest
extends DiscoveryImplTestBase {
    @Rule
    public LoggingTestWatcher watchman = new LoggingTestWatcher();

    @Before
    public void setUp() {
        Random random = new Random();
        System.setProperty("vertx.hazelcast.test.group.name", new BigInteger(128, random).toString(32));
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)new HazelcastClusterManager());
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            this.vertx = (Vertx)ar.result();
        });
        Awaitility.await().until(() -> this.vertx != null);
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    static {
        System.setProperty("hazelcast.wait.seconds.before.join", "0");
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
    }
}

