/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.spi.cluster.hazelcast.impl.Throttling;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrottlingTest {
    int threadCount = 4;
    ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        this.executorService = Executors.newFixedThreadPool(this.threadCount);
    }

    @Test
    public void testInterval() throws Exception {
        int duration = 5;
        String[] addresses = new String[]{"foo", "bar", "baz", "qux"};
        ConcurrentHashMap events = new ConcurrentHashMap(addresses.length);
        Throttling throttling = new Throttling(address -> {
            events.compute(address, (k, v) -> {
                if (v == null) {
                    v = new CopyOnWriteArrayList<Long>();
                }
                v.add(System.nanoTime());
                return v;
            });
            this.sleep(1L);
        });
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        long start = System.nanoTime();
        for (int i = 0; i < this.threadCount; ++i) {
            this.executorService.submit(() -> {
                try {
                    do {
                        this.sleepMax(5L);
                        throttling.onEvent(addresses[ThreadLocalRandom.current().nextInt(addresses.length)]);
                    } while (TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS) < (long)duration);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).pollDelay(10L, TimeUnit.MILLISECONDS).until(() -> {
            if (events.size() != addresses.length) {
                return false;
            }
            for (List nanoTimes : events.values()) {
                Long previous = null;
                for (Long nanoTime : nanoTimes) {
                    if (previous != null && TimeUnit.MILLISECONDS.convert(nanoTime - previous, TimeUnit.NANOSECONDS) < 20L) {
                        return false;
                    }
                    previous = nanoTime;
                }
            }
            return true;
        });
    }

    private void sleepMax(long time) {
        this.sleep(ThreadLocalRandom.current().nextLong(time));
    }

    private void sleep(long time) {
        try {
            TimeUnit.MILLISECONDS.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.shutdown();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(5L, TimeUnit.SECONDS));
    }
}

