/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.MapEvent;
import com.hazelcast.multimap.MultiMap;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastRegistrationInfo;
import io.vertx.spi.cluster.hazelcast.impl.Throttling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SubsMapHelper
implements EntryListener<String, HazelcastRegistrationInfo> {
    private static final Logger log = LoggerFactory.getLogger(SubsMapHelper.class);
    private final Throttling throttling;
    private final MultiMap<String, HazelcastRegistrationInfo> map;
    private final NodeSelector nodeSelector;
    private final UUID listenerId;
    private final ConcurrentMap<String, Set<RegistrationInfo>> ownSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final ConcurrentMap<String, Set<RegistrationInfo>> localSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final ReadWriteLock republishLock = new ReentrantReadWriteLock();

    public SubsMapHelper(HazelcastInstance hazelcast, NodeSelector nodeSelector) {
        this.throttling = new Throttling(this::getAndUpdate);
        this.map = hazelcast.getMultiMap("__vertx.subs");
        this.nodeSelector = nodeSelector;
        this.listenerId = this.map.addEntryListener((EntryListener)this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegistrationInfo> get(String address) {
        Lock readLock = this.republishLock.readLock();
        readLock.lock();
        try {
            ArrayList<RegistrationInfo> list;
            ArrayList<RegistrationInfo> arrayList;
            Collection remote = this.map.get((Object)address);
            int size = remote.size();
            Set local = (Set)this.localSubs.get(address);
            if (local != null) {
                arrayList = local;
                synchronized (arrayList) {
                    block12: {
                        if ((size += local.size()) != 0) break block12;
                        List<RegistrationInfo> list2 = Collections.emptyList();
                        return list2;
                    }
                    list = new ArrayList(size);
                    list.addAll(local);
                }
            }
            if (size == 0) {
                List<RegistrationInfo> list3 = Collections.emptyList();
                return list3;
            }
            list = new ArrayList<RegistrationInfo>(size);
            for (HazelcastRegistrationInfo hazelcastRegistrationInfo : remote) {
                RegistrationInfo unwrap = hazelcastRegistrationInfo.unwrap();
                list.add(unwrap);
            }
            arrayList = list;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String address, RegistrationInfo registrationInfo) {
        Lock readLock = this.republishLock.readLock();
        readLock.lock();
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.compute(address, (add, curr) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.ownSubs.compute(address, (add, curr) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.map.put((Object)address, (Object)new HazelcastRegistrationInfo(registrationInfo));
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private Set<RegistrationInfo> addToSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        Set<RegistrationInfo> res = curr != null ? curr : Collections.synchronizedSet(new LinkedHashSet());
        res.add(registrationInfo);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String address, RegistrationInfo registrationInfo) {
        Lock readLock = this.republishLock.readLock();
        readLock.lock();
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.computeIfPresent(address, (add, curr) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.ownSubs.computeIfPresent(address, (add, curr) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.map.remove((Object)address, (Object)new HazelcastRegistrationInfo(registrationInfo));
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private Set<RegistrationInfo> removeFromSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        curr.remove(registrationInfo);
        return curr.isEmpty() ? null : curr;
    }

    public void removeAllForNodes(Set<String> nodeIds) {
        for (Map.Entry entry : this.map.entrySet()) {
            HazelcastRegistrationInfo registrationInfo = (HazelcastRegistrationInfo)entry.getValue();
            if (!nodeIds.contains(registrationInfo.unwrap().nodeId())) continue;
            this.map.remove(entry.getKey(), (Object)registrationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void republishOwnSubs() {
        Lock writeLock = this.republishLock.writeLock();
        writeLock.lock();
        try {
            for (Map.Entry entry : this.ownSubs.entrySet()) {
                String address = (String)entry.getKey();
                for (RegistrationInfo registrationInfo : (Set)entry.getValue()) {
                    this.map.put((Object)address, (Object)new HazelcastRegistrationInfo(registrationInfo));
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void entryAdded(EntryEvent<String, HazelcastRegistrationInfo> event) {
        this.fireRegistrationUpdateEvent((String)event.getKey());
    }

    private void fireRegistrationUpdateEvent(String address) {
        this.throttling.onEvent(address);
    }

    private void getAndUpdate(String address) {
        if (this.nodeSelector.wantsUpdatesFor(address)) {
            List<Object> registrationInfos;
            try {
                registrationInfos = this.get(address);
            }
            catch (Exception e) {
                log.trace((Object)"A failure occurred while retrieving the updated registrations", (Throwable)e);
                registrationInfos = Collections.emptyList();
            }
            this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, registrationInfos));
        }
    }

    public void entryEvicted(EntryEvent<String, HazelcastRegistrationInfo> event) {
    }

    public void entryRemoved(EntryEvent<String, HazelcastRegistrationInfo> event) {
        this.fireRegistrationUpdateEvent((String)event.getKey());
    }

    public void entryUpdated(EntryEvent<String, HazelcastRegistrationInfo> event) {
        this.fireRegistrationUpdateEvent((String)event.getKey());
    }

    public void mapCleared(MapEvent event) {
    }

    public void mapEvicted(MapEvent event) {
    }

    public void entryExpired(EntryEvent<String, HazelcastRegistrationInfo> event) {
    }

    public void close() {
        this.map.removeEntryListener(this.listenerId);
        this.throttling.close();
    }
}

