/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.partition.PartitionService;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Completable;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.ext.healthchecks.Status;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.util.Objects;

@VertxGen
public interface ClusterHealthCheck {
    public static Handler<Promise<Status>> createProcedure(Vertx vertx) {
        Objects.requireNonNull(vertx);
        return healthCheckPromise -> vertx.executeBlocking(() -> {
            VertxInternal vertxInternal = (VertxInternal)Vertx.currentContext().owner();
            HazelcastClusterManager clusterManager = (HazelcastClusterManager)vertxInternal.clusterManager();
            PartitionService partitionService = clusterManager.getHazelcastInstance().getPartitionService();
            return new Status().setOk(partitionService.isClusterSafe());
        }, false).onComplete((Completable)healthCheckPromise);
    }
}

