/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.map.IMap;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.Completable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationListener;
import io.vertx.spi.cluster.hazelcast.ConfigUtil;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastNodeInfo;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastObjectProviderImpl;
import io.vertx.spi.cluster.hazelcast.impl.SubsMapHelper;
import io.vertx.spi.cluster.hazelcast.impl.SubsOpSerializer;
import io.vertx.spi.cluster.hazelcast.spi.HazelcastObjectProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class HazelcastClusterManager
implements ClusterManager,
MembershipListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String NODE_ID_ATTRIBUTE = "__vertx.nodeId";
    private VertxInternal vertx;
    private HazelcastInstance hazelcast;
    private HazelcastObjectProvider objectProvider;
    private volatile String nodeId;
    private NodeInfo nodeInfo;
    private SubsMapHelper subsMapHelper;
    private IMap<String, HazelcastNodeInfo> nodeInfoMap;
    private UUID membershipListenerId;
    private UUID lifecycleListenerId;
    private boolean customHazelcastCluster;
    private Set<String> nodeIds = new HashSet<String>();
    private NodeListener nodeListener;
    private RegistrationListener registrationListener;
    private volatile boolean active;
    private Config conf;
    private ExecutorService lockReleaseExec;

    public HazelcastClusterManager() {
        ServiceLoader<HazelcastObjectProvider> loader = ServiceLoader.load(HazelcastObjectProvider.class);
        for (HazelcastObjectProvider this.objectProvider : loader) {
        }
        if (this.objectProvider == null) {
            this.objectProvider = new HazelcastObjectProviderImpl();
        }
    }

    public HazelcastClusterManager(Config conf) {
        this();
        Objects.requireNonNull(conf, "The Hazelcast config cannot be null.");
        this.conf = conf;
    }

    public HazelcastClusterManager(HazelcastInstance instance) {
        this();
        Objects.requireNonNull(instance, "The Hazelcast instance cannot be null.");
        this.hazelcast = instance;
        this.customHazelcastCluster = true;
    }

    public void init(Vertx vertx) {
        this.vertx = (VertxInternal)vertx;
    }

    public void join(Completable<Void> promise) {
        this.vertx.executeBlocking(() -> {
            if (!this.active) {
                NetworkConfig cfg;
                this.active = true;
                this.lockReleaseExec = Executors.newCachedThreadPool(r -> new Thread(r, "vertx-hazelcast-service-release-lock-thread"));
                if (!this.customHazelcastCluster) {
                    if (this.conf == null) {
                        this.conf = this.loadConfig();
                        if (this.conf == null) {
                            log.warn((Object)"Cannot find cluster configuration on 'vertx.hazelcast.config' system property, on the classpath, or specified programmatically. Using default hazelcast configuration");
                            this.conf = new Config();
                        }
                    }
                    this.conf.setProperty("hazelcast.shutdownhook.enabled", "false");
                    this.nodeId = UUID.randomUUID().toString();
                    this.conf.getMemberAttributeConfig().setAttribute(NODE_ID_ATTRIBUTE, this.nodeId);
                    this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.conf);
                } else {
                    this.nodeId = this.hazelcast.getCluster().getLocalMember().getAttribute(NODE_ID_ATTRIBUTE);
                    if (this.nodeId == null) {
                        throw new VertxException("Vert.x node id not defined in Hazelcast member attributes", true);
                    }
                }
                Module hzMod = NetworkConfig.class.getModule();
                if (PlatformDependent.isOsx() && hzMod.isNamed() && (cfg = this.hazelcast.getConfig().getNetworkConfig()).getJoin().getMulticastConfig().isEnabled()) {
                    throw new VertxException("Hazelcast detected on module path multicast join not supported on Mac");
                }
                this.subsMapHelper = new SubsMapHelper(this.hazelcast, this.registrationListener);
                this.membershipListenerId = this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
                this.lifecycleListenerId = this.hazelcast.getLifecycleService().addLifecycleListener((LifecycleListener)this);
                this.nodeInfoMap = this.hazelcast.getMap("__vertx.nodeInfo");
                this.objectProvider.onJoin(this.vertx, new ConversionUtils(), this.hazelcast, this.lockReleaseExec);
            }
            return null;
        }).onComplete(promise);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public List<String> getNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Member member : this.hazelcast.getCluster().getMembers()) {
            String nodeId = member.getAttribute(NODE_ID_ATTRIBUTE);
            if (nodeId == null) continue;
            list.add(nodeId);
        }
        return list;
    }

    public void registrationListener(RegistrationListener listener) {
        this.registrationListener = listener;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInfo(NodeInfo nodeInfo, Completable<Void> promise) {
        HazelcastClusterManager hazelcastClusterManager = this;
        synchronized (hazelcastClusterManager) {
            this.nodeInfo = nodeInfo;
        }
        HazelcastNodeInfo value = this.wrapNodeInfo(nodeInfo);
        this.vertx.executeBlocking(() -> {
            this.nodeInfoMap.put((Object)this.nodeId, (Object)value);
            return null;
        }, false).onComplete(promise);
    }

    private HazelcastNodeInfo wrapNodeInfo(NodeInfo nodeInfo) {
        return new HazelcastNodeInfo(nodeInfo);
    }

    public synchronized NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void getNodeInfo(String nodeId, Completable<NodeInfo> promise) {
        this.vertx.executeBlocking(() -> {
            HazelcastNodeInfo value = (HazelcastNodeInfo)this.nodeInfoMap.get((Object)nodeId);
            if (value != null) {
                return value.unwrap();
            }
            throw new VertxException("Not a member of the cluster", true);
        }, false).onComplete(promise);
    }

    public <K, V> void getAsyncMap(String name, Completable<AsyncMap<K, V>> promise) {
        promise.succeed(this.objectProvider.getAsyncMap(name));
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.objectProvider.getSyncMap(name);
    }

    public void getLockWithTimeout(String name, long timeout, Completable<Lock> promise) {
        this.vertx.executeBlocking(() -> this.objectProvider.getLockWithTimeout(name, timeout), false).onComplete(promise);
    }

    public void getCounter(String name, Completable<Counter> promise) {
        promise.succeed((Object)this.objectProvider.createCounter(name));
    }

    public void leave(Completable<Void> promise) {
        this.vertx.executeBlocking(() -> {
            HazelcastClusterManager hazelcastClusterManager = this;
            synchronized (hazelcastClusterManager) {
                if (this.active) {
                    this.active = false;
                    this.lockReleaseExec.shutdown();
                    this.subsMapHelper.close();
                    boolean left = this.hazelcast.getCluster().removeMembershipListener(this.membershipListenerId);
                    if (!left) {
                        log.warn((Object)"No membership listener");
                    }
                    this.hazelcast.getLifecycleService().removeLifecycleListener(this.lifecycleListenerId);
                    while (!this.customHazelcastCluster && this.hazelcast.getLifecycleService().isRunning()) {
                        try {
                            this.hazelcast.getLifecycleService().shutdown();
                        }
                        catch (RejectedExecutionException ignore) {
                            log.debug((Object)"Rejected execution of the shutdown operation, retrying");
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException t) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            return null;
        }).onComplete(promise);
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String nid = member.getAttribute(NODE_ID_ATTRIBUTE);
        try {
            if (this.nodeListener != null) {
                this.nodeIds.add(nid);
                this.nodeListener.nodeAdded(nid);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberAdded", t);
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        Member member = membershipEvent.getMember();
        String nid = member.getAttribute(NODE_ID_ATTRIBUTE);
        try {
            this.membersRemoved(Collections.singleton(nid));
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberRemoved", t);
        }
    }

    private synchronized void membersRemoved(Set<String> ids) {
        this.cleanSubs(ids);
        this.cleanNodeInfos(ids);
        this.nodeInfoMap.put((Object)this.nodeId, (Object)this.wrapNodeInfo(this.getNodeInfo()));
        this.registrationListener.registrationsLost();
        this.republishOwnSubs();
        if (this.nodeListener != null) {
            this.nodeIds.removeAll(ids);
            ids.forEach(arg_0 -> ((NodeListener)this.nodeListener).nodeLeft(arg_0));
        }
    }

    private void cleanSubs(Set<String> ids) {
        this.subsMapHelper.removeAllForNodes(ids);
    }

    private void cleanNodeInfos(Set<String> ids) {
        ids.forEach(arg_0 -> this.nodeInfoMap.remove(arg_0));
    }

    private void republishOwnSubs() {
        this.vertx.executeBlocking(() -> {
            this.subsMapHelper.republishOwnSubs();
            return null;
        }, false);
    }

    public synchronized void stateChanged(LifecycleEvent lifecycleEvent) {
        if (!this.active) {
            return;
        }
        if (lifecycleEvent.getState() == LifecycleEvent.LifecycleState.MERGED) {
            List<String> currentNodes = this.getNodes();
            HashSet<String> newNodes = new HashSet<String>(currentNodes);
            newNodes.removeAll(this.nodeIds);
            HashSet<String> removedMembers = new HashSet<String>(this.nodeIds);
            removedMembers.removeAll(currentNodes);
            if (this.nodeListener != null) {
                for (String nodeId : newNodes) {
                    this.nodeListener.nodeAdded(nodeId);
                }
            }
            this.membersRemoved(removedMembers);
            this.nodeIds.retainAll(currentNodes);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Completable<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsMapHelper::put, address, registrationInfo, promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Completable<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsMapHelper::remove, address, registrationInfo, promise);
    }

    public void getRegistrations(String address, Completable<List<RegistrationInfo>> promise) {
        this.vertx.executeBlocking(() -> this.subsMapHelper.get(address), false).onComplete(promise);
    }

    public String clusterHost() {
        String host;
        if (!this.customHazelcastCluster && (host = System.getProperty("hazelcast.local.localAddress")) != null) {
            return host;
        }
        if (!this.customHazelcastCluster && this.conf.getNetworkConfig().getPublicAddress() == null) {
            return this.hazelcast.getCluster().getLocalMember().getAddress().getHost();
        }
        return null;
    }

    public String clusterPublicHost() {
        String host;
        if (!this.customHazelcastCluster && (host = System.getProperty("hazelcast.local.publicAddress")) != null) {
            return host;
        }
        if (!this.customHazelcastCluster && (host = this.conf.getNetworkConfig().getPublicAddress()) != null) {
            return host;
        }
        return null;
    }

    public Config getConfig() {
        return this.conf;
    }

    public void setConfig(Config config) {
        this.conf = config;
    }

    public Config loadConfig() {
        return ConfigUtil.loadConfig();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcast;
    }
}

