/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import java.io.IOException;

public class DataSerializableHolder
implements DataSerializable {
    private ClusterSerializable clusterSerializable;

    public DataSerializableHolder() {
    }

    DataSerializableHolder(ClusterSerializable clusterSerializable) {
        this.clusterSerializable = clusterSerializable;
    }

    public final void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        String fqn = this.clusterSerializable instanceof Buffer ? "io.vertx.core.buffer.Buffer" : this.clusterSerializable.getClass().getName();
        objectDataOutput.writeUTF(fqn);
        Buffer buffer = Buffer.buffer();
        this.clusterSerializable.writeToBuffer(buffer);
        byte[] bytes = buffer.getBytes();
        objectDataOutput.writeInt(bytes.length);
        objectDataOutput.write(bytes);
    }

    public final void readData(ObjectDataInput objectDataInput) throws IOException {
        String className = objectDataInput.readUTF();
        int length = objectDataInput.readInt();
        byte[] bytes = new byte[length];
        objectDataInput.readFully(bytes);
        try {
            switch (className) {
                case "io.vertx.core.buffer.Buffer": {
                    this.clusterSerializable = Buffer.buffer();
                    break;
                }
                default: {
                    Class<?> clazz = this.loadClass(className);
                    this.clusterSerializable = (ClusterSerializable)clazz.newInstance();
                }
            }
            this.clusterSerializable.readFromBuffer(0, Buffer.buffer((byte[])bytes));
        }
        catch (Exception e) {
            throw new IOException("Failed to load class " + className, e);
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (tccl != null) {
                return tccl.loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ConversionUtils.class.getClassLoader().loadClass(className);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSerializableHolder)) {
            return false;
        }
        DataSerializableHolder that = (DataSerializableHolder)o;
        return this.clusterSerializable != null ? this.clusterSerializable.equals(that.clusterSerializable) : that.clusterSerializable == null;
    }

    public final int hashCode() {
        return this.clusterSerializable != null ? this.clusterSerializable.hashCode() : 0;
    }

    public ClusterSerializable clusterSerializable() {
        return this.clusterSerializable;
    }
}

