/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.map.IMap;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public class HazelcastAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final VertxInternal vertx;
    private final IMap<K, V> map;
    private final ConversionUtils conversionUtils;

    public HazelcastAsyncMap(VertxInternal vertx, ConversionUtils conversionUtils, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
        this.conversionUtils = conversionUtils;
    }

    public Future<V> get(K k) {
        K kk = this.conversionUtils.convertParam(k);
        ContextInternal context = this.vertx.getOrCreateContext();
        return Future.fromCompletionStage((CompletionStage)this.map.getAsync(kk), (Context)context).map(this.conversionUtils::convertReturn);
    }

    public Future<Void> put(K k, V v) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        ContextInternal context = this.vertx.getOrCreateContext();
        return Future.fromCompletionStage((CompletionStage)this.map.setAsync(kk, vv), (Context)context);
    }

    public Future<V> putIfAbsent(K k, V v) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        return this.vertx.executeBlocking(() -> this.conversionUtils.convertReturn(this.map.putIfAbsent(kk, vv)), false);
    }

    public Future<Void> put(K k, V v, long ttl) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        ContextInternal context = this.vertx.getOrCreateContext();
        CompletionStage completionStage = this.map.setAsync(kk, vv, ttl, TimeUnit.MILLISECONDS);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)context);
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        return this.vertx.executeBlocking(() -> this.conversionUtils.convertReturn(this.map.putIfAbsent(kk, vv, ttl, TimeUnit.MILLISECONDS)), false);
    }

    public Future<V> remove(K k) {
        K kk = this.conversionUtils.convertParam(k);
        ContextInternal context = this.vertx.getOrCreateContext();
        CompletionStage completionStage = this.map.removeAsync(kk);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)context).map(this.conversionUtils::convertReturn);
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        return this.vertx.executeBlocking(() -> this.map.remove(kk, vv), false);
    }

    public Future<V> replace(K k, V v) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(v);
        return this.vertx.executeBlocking(() -> this.conversionUtils.convertReturn(this.map.replace(kk, vv)), false);
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        K kk = this.conversionUtils.convertParam(k);
        V vv = this.conversionUtils.convertParam(oldValue);
        V vvv = this.conversionUtils.convertParam(newValue);
        return this.vertx.executeBlocking(() -> this.map.replace(kk, vv, vvv), false);
    }

    public Future<Void> clear() {
        return this.vertx.executeBlocking(() -> {
            this.map.clear();
            return null;
        }, false);
    }

    public Future<Integer> size() {
        return this.vertx.executeBlocking(() -> this.map.size(), false);
    }

    public Future<Set<K>> keys() {
        return this.vertx.executeBlocking(() -> {
            HashSet set = new HashSet();
            for (Object kk : this.map.keySet()) {
                Object k = this.conversionUtils.convertReturn(kk);
                set.add(k);
            }
            return set;
        }, false);
    }

    public Future<List<V>> values() {
        return this.vertx.executeBlocking(() -> {
            ArrayList list = new ArrayList();
            for (Object vv : this.map.values()) {
                Object v = this.conversionUtils.convertReturn(vv);
                list.add(v);
            }
            return list;
        }, false);
    }

    public Future<Map<K, V>> entries() {
        return this.vertx.executeBlocking(() -> {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.map.entrySet()) {
                Object k = this.conversionUtils.convertReturn(entry.getKey());
                Object v = this.conversionUtils.convertReturn(entry.getValue());
                result.put(k, v);
            }
            return result;
        }, false);
    }
}

