/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.shareddata.Counter;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;

public class HazelcastCounter
implements Counter {
    private final VertxInternal vertx;
    private final IMap<String, Long> counterMap;
    private final String name;

    public HazelcastCounter(VertxInternal vertx, IMap<String, Long> counterMap, String name) {
        this.vertx = vertx;
        this.counterMap = counterMap;
        this.name = name;
        counterMap.putIfAbsent((Object)name, (Object)0L);
    }

    public Future<Long> get() {
        return Future.fromCompletionStage((CompletionStage)this.counterMap.getAsync((Object)this.name), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    public Future<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public Future<Long> decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public Future<Long> addAndGet(long value) {
        return Future.fromCompletionStage((CompletionStage)this.counterMap.submitToKey((Object)this.name, (EntryProcessor & Serializable)entry -> {
            long newValue = (Long)entry.getValue() + value;
            entry.setValue(newValue);
            return newValue;
        }), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Long> getAndAdd(long value) {
        return Future.fromCompletionStage((CompletionStage)this.counterMap.submitToKey((Object)this.name, (EntryProcessor & Serializable)entry -> {
            long oldValue = (Long)entry.getValue();
            entry.setValue(oldValue + value);
            return oldValue;
        }), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Boolean> compareAndSet(long expected, long value) {
        return Future.fromCompletionStage((CompletionStage)this.counterMap.submitToKey((Object)this.name, (EntryProcessor & Serializable)entry -> {
            if ((Long)entry.getValue() == expected) {
                entry.setValue(value);
                return true;
            }
            return false;
        }), (Context)this.vertx.getOrCreateContext());
    }
}

