/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.NodeInfo;
import java.io.IOException;

public class HazelcastNodeInfo
implements DataSerializable {
    private NodeInfo nodeInfo;

    public HazelcastNodeInfo() {
    }

    public HazelcastNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public final void writeData(ObjectDataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.nodeInfo.host());
        dataOutput.writeInt(this.nodeInfo.port());
        JsonObject metadata = this.nodeInfo.metadata();
        dataOutput.writeByteArray(metadata != null ? metadata.toBuffer().getBytes() : null);
    }

    public final void readData(ObjectDataInput dataInput) throws IOException {
        String host = dataInput.readUTF();
        int port = dataInput.readInt();
        byte[] bytes = dataInput.readByteArray();
        this.nodeInfo = new NodeInfo(host, port, bytes != null ? new JsonObject(Buffer.buffer((byte[])bytes)) : null);
    }

    public final NodeInfo unwrap() {
        return this.nodeInfo;
    }
}

