/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import io.vertx.core.VertxException;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastCounter;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastLock;
import io.vertx.spi.cluster.hazelcast.spi.HazelcastObjectProvider;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class HazelcastObjectProviderImpl
implements HazelcastObjectProvider {
    private static final String MAP_COUNTER_NAME = "__vertx.map.counter";
    private static final String MAP_LOCK_NAME = "__vertx.map.lock";
    private VertxInternal vertx;
    private HazelcastInstance hazelcast;
    private ExecutorService lockReleaseExec;
    private ConversionUtils conversionUtils;

    @Override
    public void onJoin(VertxInternal vertx, ConversionUtils conversionUtils, HazelcastInstance hazelcast, ExecutorService lockReleaseExec) {
        this.vertx = vertx;
        this.hazelcast = hazelcast;
        this.conversionUtils = conversionUtils;
        this.lockReleaseExec = lockReleaseExec;
    }

    @Override
    public <K, V> AsyncMap<K, V> getAsyncMap(String name) {
        return new HazelcastAsyncMap(this.vertx, this.conversionUtils, this.hazelcast.getMap(name));
    }

    @Override
    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.hazelcast.getMap(name);
    }

    @Override
    public Lock getLockWithTimeout(String name, long timeout) {
        long start;
        IMap lockMap = this.hazelcast.getMap(MAP_LOCK_NAME);
        boolean locked = false;
        long remaining = timeout;
        do {
            start = System.nanoTime();
            try {
                locked = lockMap.tryLock((Object)name, timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!locked && (remaining -= TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)) > 0L);
        if (locked) {
            return new HazelcastLock(lockMap, name, this.lockReleaseExec);
        }
        throw new VertxException("Timed out waiting to get lock " + name, true);
    }

    @Override
    public Counter createCounter(String name) {
        return new HazelcastCounter(this.vertx, (IMap<String, Long>)this.hazelcast.getMap(MAP_COUNTER_NAME), name);
    }
}

