/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import io.vertx.core.Completable;
import io.vertx.core.ThreadingModel;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.cluster.RegistrationInfo;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class SubsOpSerializer {
    private final EventExecutor executor;

    private SubsOpSerializer(VertxInternal vertx) {
        ContextInternal worker = vertx.createContext(ThreadingModel.WORKER);
        this.executor = worker.executor();
    }

    public static SubsOpSerializer get(ContextInternal context) {
        ConcurrentMap contextData = context.contextData();
        SubsOpSerializer instance = (SubsOpSerializer)contextData.get(SubsOpSerializer.class);
        if (instance == null) {
            SubsOpSerializer candidate = new SubsOpSerializer(context.owner());
            SubsOpSerializer previous = contextData.putIfAbsent(SubsOpSerializer.class, candidate);
            instance = previous == null ? candidate : previous;
        }
        return instance;
    }

    public void execute(BiConsumer<String, RegistrationInfo> op, String address, RegistrationInfo registrationInfo, Completable<Void> promise) {
        this.executor.execute(() -> {
            try {
                op.accept(address, registrationInfo);
                promise.succeed();
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        });
    }
}

