/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.ProcedureException;

public class StatusHelper {
    public static JsonObject from(String name, AsyncResult<Status> ar) {
        JsonObject json = new JsonObject();
        if (name != null) {
            json.put("id", name);
        }
        if (ar.succeeded()) {
            if (ar.result() != null && !((Status)ar.result()).isOk()) {
                json.put("status", "DOWN");
            } else {
                json.put("status", "UP");
            }
            if (ar.result() != null && ((Status)ar.result()).getData() != null && !((Status)ar.result()).getData().isEmpty()) {
                json.put("data", ((Status)ar.result()).getData());
            }
            if (ar.result() != null && ((Status)ar.result()).isProcedureInError()) {
                json.put("error", Boolean.valueOf(true));
            }
        } else {
            json.put("status", "DOWN").put("data", new JsonObject().put("cause", ar.cause().getMessage()));
        }
        return json;
    }

    public static JsonObject onError(String name, ProcedureException e) {
        JsonObject json = new JsonObject();
        if (name != null) {
            json.put("id", name);
        }
        return json.put("status", "DOWN").put("data", new JsonObject().put("procedure-execution-failure", Boolean.valueOf(true)).put("cause", e.getMessage()));
    }

    public static boolean isUp(Future<JsonObject> json) {
        return !json.failed() && StatusHelper.isUp((JsonObject)json.result());
    }

    public static boolean isUp(JsonObject json) {
        return json == null || "UP".equals(json.getString("status")) || "UP".equals(json.getString("outcome"));
    }
}

