require 'vertx/vertx'
require 'vertx-health-checks/health_checks'
require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.healthchecks.HealthCheckHandler
module VertxHealthChecks
  #  A Vert.x Web handler on which you register health check procedure. It computes the outcome status (`UP` or `DOWN`)
  #  . When the handler process a HTTP request, it computes the global outcome and build a HTTP response as follows:
  #  <p>
  #  <ul>
  #  <li>204 - status is `UP` but no procedures installed (no payload)</li>
  #  <li>200 - status is `UP`, the payload contains the result of the installed procedures</li>
  #  <li>503 - status is `DOWN`, the payload contains the result of the installed procedures</li>
  #  <li>500 - status is `DOWN`, the payload contains the result of the installed procedures, one of the
  #  procedure has failed</li>
  #  </ul>
  class HealthCheckHandler
    # @private
    # @param j_del [::VertxHealthChecks::HealthCheckHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxHealthChecks::HealthCheckHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HealthCheckHandler
    end
    def @@j_api_type.wrap(obj)
      HealthCheckHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtHealthchecks::HealthCheckHandler.java_class
    end
    # @param [::VertxWeb::RoutingContext] arg0 
    # @return [void]
    def handle(arg0=nil)
      if arg0.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(arg0.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{arg0})"
    end
    #  Creates an instance of the default implementation of the {::VertxHealthChecks::HealthCheckHandler}.
    #  This function creates a new instance of {::VertxHealthChecks::HealthChecks}.
    # @param [::Vertx::Vertx] vertx the Vert.x instance, must not be <code>null</code>
    # @param [::VertxAuthCommon::AuthProvider] provider the Authentication provider used to authenticate the HTTP request
    # @return [::VertxHealthChecks::HealthCheckHandler] the created instance
    def self.create(vertx=nil,provider=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && provider == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxHealthChecks::HealthCheckHandler)
      elsif vertx.class.method_defined?(:j_del) && provider.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuth::AuthProvider.java_class]).call(vertx.j_del,provider.j_del),::VertxHealthChecks::HealthCheckHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{provider})"
    end
    #  Creates an instance of the default implementation of the {::VertxHealthChecks::HealthCheckHandler}.
    # @param [::VertxHealthChecks::HealthChecks] hc the health checks object to use, must not be <code>null</code>
    # @param [::VertxAuthCommon::AuthProvider] provider 
    # @return [::VertxHealthChecks::HealthCheckHandler] the created instance
    def self.create_with_health_checks(hc=nil,provider=nil)
      if hc.class.method_defined?(:j_del) && !block_given? && provider == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:createWithHealthChecks, [Java::IoVertxExtHealthchecks::HealthChecks.java_class]).call(hc.j_del),::VertxHealthChecks::HealthCheckHandler)
      elsif hc.class.method_defined?(:j_del) && provider.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:createWithHealthChecks, [Java::IoVertxExtHealthchecks::HealthChecks.java_class,Java::IoVertxExtAuth::AuthProvider.java_class]).call(hc.j_del,provider.j_del),::VertxHealthChecks::HealthCheckHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create_with_health_checks(#{hc},#{provider})"
    end
    #  Registers a health check procedure.
    #  <p>
    #  The procedure is a  taking a  of {Hash} as parameter. Procedures are
    #  asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
    #  failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
    #  procedure outcome is considered as `UP`. If the future is completed with a (not-null) {Hash}, the
    #  procedure outcome is the received status.
    # @param [String] name the name of the procedure, must not be <code>null</code> or empty
    # @yield the procedure, must not be <code>null</code>
    # @return [self]
    def register(name=nil)
      if name.class == String && block_given?
        @j_del.java_method(:register, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtHealthchecks::Status))) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling register(#{name})"
    end
    #  Unregisters a procedure.
    # @param [String] name the name of the procedure
    # @return [self]
    def unregister(name=nil)
      if name.class == String && !block_given?
        @j_del.java_method(:unregister, [Java::java.lang.String.java_class]).call(name)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unregister(#{name})"
    end
  end
end
