/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.Procedure;
import io.vertx.ext.healthchecks.impl.ProcedureException;
import io.vertx.ext.healthchecks.impl.StatusHelper;
import java.util.Objects;

class DefaultProcedure
implements Procedure {
    private final Handler<Future<Status>> handler;
    private final String name;
    private final Vertx vertx;
    private final long timeout;

    DefaultProcedure(Vertx vertx, String name, long timeout, Handler<Future<Status>> handler) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(name);
        Objects.requireNonNull(handler);
        this.timeout = timeout;
        this.name = name;
        this.handler = handler;
        this.vertx = vertx;
    }

    @Override
    public void check(Handler<JsonObject> resultHandler) {
        Future future = Future.future().setHandler(ar -> {
            if (ar.cause() instanceof ProcedureException) {
                resultHandler.handle((Object)StatusHelper.onError(this.name, (ProcedureException)ar.cause()));
            } else {
                resultHandler.handle((Object)StatusHelper.from(this.name, (AsyncResult<Status>)ar));
            }
        });
        if (this.timeout >= 0L) {
            this.vertx.setTimer(this.timeout, l -> {
                if (!future.isComplete()) {
                    future.fail((Throwable)new ProcedureException("Timeout"));
                }
            });
        }
        try {
            this.handler.handle((Object)future);
        }
        catch (Exception e) {
            future.fail((Throwable)new ProcedureException(e));
        }
    }
}

