/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.healthchecks;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.ext.healthchecks.Status;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.Future;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.healthchecks.HealthChecks original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.healthchecks.HealthChecks.class)
public class HealthChecks {

  public static final io.vertx.lang.rxjava.TypeArg<HealthChecks> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new HealthChecks((io.vertx.ext.healthchecks.HealthChecks) obj),
    HealthChecks::getDelegate
  );

  private final io.vertx.ext.healthchecks.HealthChecks delegate;
  
  public HealthChecks(io.vertx.ext.healthchecks.HealthChecks delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.healthchecks.HealthChecks getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of the default implementation of {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}.
   * @param vertx the instance of Vert.x, must not be <code>null</code>
   * @return the created instance
   */
  public static HealthChecks create(Vertx vertx) { 
    HealthChecks ret = HealthChecks.newInstance(io.vertx.ext.healthchecks.HealthChecks.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter.
   * Procedures are asynchronous, and <strong>must</strong> complete or fail the given .
   * If the future object is failed, the procedure outcome is considered as `DOWN`. If the future is
   * completed without any object, the procedure outcome is considered as `UP`. If the future is completed
   * with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the procedure outcome is the received status.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public HealthChecks register(String name, Handler<Future<Status>> procedure) { 
    delegate.register(name, new Handler<io.vertx.core.Future<io.vertx.ext.healthchecks.Status>>() {
      public void handle(io.vertx.core.Future<io.vertx.ext.healthchecks.Status> event) {
        procedure.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Unregisters a procedure.
   * @param name the name of the procedure
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public HealthChecks unregister(String name) { 
    delegate.unregister(name);
    return this;
  }

  /**
   * Invokes the registered procedures and computes the outcome.
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received the computed .
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public HealthChecks invoke(Handler<JsonObject> resultHandler) { 
    delegate.invoke(resultHandler);
    return this;
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures. It computes the overall
   * outcome.
   * @param name 
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received an  marked as failed if the procedure with the given name cannot be found or invoked.
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public HealthChecks invoke(String name, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.invoke(name, resultHandler);
    return this;
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures. It computes the overall
   * outcome.
   * @param name 
   * @return 
   */
  public Single<JsonObject> rxInvoke(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      invoke(name, fut);
    }));
  }


  public static  HealthChecks newInstance(io.vertx.ext.healthchecks.HealthChecks arg) {
    return arg != null ? new HealthChecks(arg) : null;
  }
}
