/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.healthchecks;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.ext.healthchecks.Status;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.web.RoutingContext;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.ext.auth.AuthProvider;

/**
 * A Vert.x Web handler on which you register health check procedure. It computes the outcome status (`UP` or `DOWN`)
 * . When the handler process a HTTP request, it computes the global outcome and build a HTTP response as follows:
 * <p>
 * <ul>
 * <li>204 - status is `UP` but no procedures installed (no payload)</li>
 * <li>200 - status is `UP`, the payload contains the result of the installed procedures</li>
 * <li>503 - status is `DOWN`, the payload contains the result of the installed procedures</li>
 * <li>500 - status is `DOWN`, the payload contains the result of the installed procedures, one of the
 * procedure has failed</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.healthchecks.HealthCheckHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.healthchecks.HealthCheckHandler.class)
public class HealthCheckHandler implements io.vertx.core.Handler<RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HealthCheckHandler that = (HealthCheckHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<HealthCheckHandler> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new HealthCheckHandler((io.vertx.ext.healthchecks.HealthCheckHandler) obj),
    HealthCheckHandler::getDelegate
  );

  private final io.vertx.ext.healthchecks.HealthCheckHandler delegate;
  
  public HealthCheckHandler(io.vertx.ext.healthchecks.HealthCheckHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.healthchecks.HealthCheckHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}.
   * This function creates a new instance of {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}.
   * @param vertx the Vert.x instance, must not be <code>null</code>
   * @param provider the Authentication provider used to authenticate the HTTP request
   * @return the created instance
   */
  public static HealthCheckHandler create(Vertx vertx, AuthProvider provider) { 
    HealthCheckHandler ret = HealthCheckHandler.newInstance(io.vertx.ext.healthchecks.HealthCheckHandler.create(vertx.getDelegate(), provider.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}.
   * This function creates a new instance of {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}.
   * @param vertx the Vert.x instance, must not be <code>null</code>
   * @return the created instance
   */
  public static HealthCheckHandler create(Vertx vertx) { 
    HealthCheckHandler ret = HealthCheckHandler.newInstance(io.vertx.ext.healthchecks.HealthCheckHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}.
   * @param hc the health checks object to use, must not be <code>null</code>
   * @param provider 
   * @return the created instance
   */
  public static HealthCheckHandler createWithHealthChecks(HealthChecks hc, AuthProvider provider) { 
    HealthCheckHandler ret = HealthCheckHandler.newInstance(io.vertx.ext.healthchecks.HealthCheckHandler.createWithHealthChecks(hc.getDelegate(), provider.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}.
   * @param hc the health checks object to use
   * @return the created instance
   */
  public static HealthCheckHandler createWithHealthChecks(HealthChecks hc) { 
    HealthCheckHandler ret = HealthCheckHandler.newInstance(io.vertx.ext.healthchecks.HealthCheckHandler.createWithHealthChecks(hc.getDelegate()));
    return ret;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter. Procedures are
   * asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
   * failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
   * procedure outcome is considered as `UP`. If the future is completed with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the
   * procedure outcome is the received status.
   * <p>
   * This method uses a 1s timeout. To configure the timeout use {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler#register}.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}
   */
  public HealthCheckHandler register(String name, Handler<Future<Status>> procedure) { 
    delegate.register(name, new Handler<io.vertx.core.Future<io.vertx.ext.healthchecks.Status>>() {
      public void handle(io.vertx.core.Future<io.vertx.ext.healthchecks.Status> event) {
        procedure.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter. Procedures are
   * asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
   * failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
   * procedure outcome is considered as `UP`. If the future is completed with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the
   * procedure outcome is the received status.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param timeout the procedure timeout
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}
   */
  public HealthCheckHandler register(String name, long timeout, Handler<Future<Status>> procedure) { 
    delegate.register(name, timeout, new Handler<io.vertx.core.Future<io.vertx.ext.healthchecks.Status>>() {
      public void handle(io.vertx.core.Future<io.vertx.ext.healthchecks.Status> event) {
        procedure.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Unregisters a procedure.
   * @param name the name of the procedure
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthCheckHandler}
   */
  public HealthCheckHandler unregister(String name) { 
    delegate.unregister(name);
    return this;
  }


  public static  HealthCheckHandler newInstance(io.vertx.ext.healthchecks.HealthCheckHandler arg) {
    return arg != null ? new HealthCheckHandler(arg) : null;
  }
}
