/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.HealthChecksImpl;
import io.vertx.ext.healthchecks.impl.StatusHelper;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;

public class HealthCheckHandlerImpl
implements HealthCheckHandler {
    private static Logger log = LoggerFactory.getLogger(HealthCheckHandler.class);
    private HealthChecks healthChecks;
    private final AuthProvider authProvider;

    public HealthCheckHandlerImpl(Vertx vertx, AuthProvider provider) {
        this.healthChecks = new HealthChecksImpl(vertx);
        this.authProvider = provider;
    }

    public HealthCheckHandlerImpl(HealthChecks hc, AuthProvider provider) {
        this.healthChecks = Objects.requireNonNull(hc);
        this.authProvider = provider;
    }

    @Override
    public HealthCheckHandler register(String name, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, procedure);
        return this;
    }

    @Override
    public HealthCheckHandler register(String name, long timeout, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, timeout, procedure);
        return this;
    }

    public void handle(RoutingContext rc) {
        String path = rc.request().path();
        String mount = rc.mountPoint();
        String route = rc.currentRoute().getPath();
        if (mount != null && path.startsWith(mount)) {
            path = path.substring(mount.length());
        }
        String id = route != null && path.startsWith(route) ? path.substring(route.length()) : path;
        if (this.authProvider != null) {
            JsonObject authData = new JsonObject();
            rc.request().headers().forEach(entry -> authData.put((String)entry.getKey(), (String)entry.getValue()));
            rc.request().params().forEach(entry -> authData.put((String)entry.getKey(), (String)entry.getValue()));
            if (rc.request().method() == HttpMethod.POST && rc.request().getHeader(HttpHeaders.CONTENT_TYPE) != null && rc.request().getHeader(HttpHeaders.CONTENT_TYPE).contains("application/json")) {
                try {
                    JsonObject json = rc.getBodyAsJson();
                    if (json != null) {
                        authData.mergeIn(json);
                    }
                }
                catch (Exception err) {
                    log.error((Object)"Invalid authentication json body", (Throwable)err);
                }
            }
            this.authProvider.authenticate(authData, ar -> {
                if (ar.failed()) {
                    rc.response().setStatusCode(403).end();
                } else {
                    this.healthChecks.invoke(id, this.healthReportHandler(rc));
                }
            });
        } else {
            this.healthChecks.invoke(id, this.healthReportHandler(rc));
        }
    }

    private Handler<AsyncResult<JsonObject>> healthReportHandler(RoutingContext rc) {
        return json -> {
            HttpServerResponse response = rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json;charset=UTF-8");
            if (json.failed()) {
                if (json.cause().getMessage().toLowerCase().contains("not found")) {
                    response.setStatusCode(404);
                } else {
                    response.setStatusCode(400);
                }
                response.end("{\"message\": \"" + json.cause().getMessage() + "\"}");
            } else {
                this.buildResponse((JsonObject)json.result(), response);
            }
        };
    }

    private void buildResponse(JsonObject json, HttpServerResponse response) {
        int status;
        int n = status = StatusHelper.isUp(json) ? 200 : 503;
        if (status == 503 && this.hasProcedureError(json)) {
            status = 500;
        }
        JsonArray checks = json.getJsonArray("checks");
        if (status == 200 && checks != null && checks.isEmpty()) {
            response.setStatusCode(204).end();
            return;
        }
        response.setStatusCode(status).end(this.transform(json));
    }

    @Override
    public synchronized HealthCheckHandler unregister(String name) {
        this.healthChecks.unregister(name);
        return this;
    }

    private boolean hasProcedureError(JsonObject json) {
        JsonObject data = json.getJsonObject("data");
        if (data != null && data.getBoolean("procedure-execution-failure", Boolean.valueOf(false)).booleanValue()) {
            return true;
        }
        JsonArray checks = json.getJsonArray("checks");
        if (checks != null) {
            for (int i = 0; i < checks.size(); ++i) {
                JsonObject check = checks.getJsonObject(i);
                if (!this.hasProcedureError(check)) continue;
                return true;
            }
        }
        return false;
    }

    private String transform(JsonObject json) {
        String status = json.getString("status");
        String outcome = json.getString("outcome");
        if (status != null && outcome == null) {
            json.put("outcome", status);
        }
        return json.encode();
    }
}

