/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.Procedure;
import io.vertx.ext.healthchecks.impl.ProcedureException;
import io.vertx.ext.healthchecks.impl.StatusHelper;
import java.util.Objects;

class DefaultProcedure
implements Procedure {
    private final Handler<Promise<Status>> handler;
    private final String name;
    private final Vertx vertx;
    private final long timeout;

    DefaultProcedure(Vertx vertx, String name, long timeout, Handler<Promise<Status>> handler) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(name);
        Objects.requireNonNull(handler);
        this.timeout = timeout;
        this.name = name;
        this.handler = handler;
        this.vertx = vertx;
    }

    @Override
    public void check(Handler<JsonObject> resultHandler) {
        try {
            Promise promise = Promise.promise();
            promise.future().onComplete(ar -> {
                if (ar.cause() instanceof ProcedureException) {
                    resultHandler.handle((Object)StatusHelper.onError(this.name, (ProcedureException)ar.cause()));
                } else {
                    resultHandler.handle((Object)StatusHelper.from(this.name, ar));
                }
            });
            if (this.timeout >= 0L) {
                this.vertx.setTimer(this.timeout, l -> promise.tryFail((Throwable)new ProcedureException("Timeout")));
            }
            try {
                this.handler.handle((Object)promise);
            }
            catch (Exception e) {
                promise.tryFail((Throwable)new ProcedureException(e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

