/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.ProcedureException;

public class StatusHelper {
    public static JsonObject from(String name, AsyncResult<?> ar) {
        Status res = null;
        if (ar.result() instanceof Status) {
            res = (Status)ar.result();
        } else if (ar.result() instanceof JsonObject) {
            res = new Status((JsonObject)ar.result());
        }
        JsonObject json = new JsonObject();
        if (name != null) {
            json.put("id", (Object)name);
        }
        if (ar.succeeded()) {
            if (res != null && !res.isOk()) {
                json.put("status", (Object)"DOWN");
            } else {
                json.put("status", (Object)"UP");
            }
            if (res != null && res.getData() != null && !res.getData().isEmpty()) {
                json.put("data", (Object)res.getData());
            }
            if (res != null && res.isProcedureInError()) {
                json.put("error", (Object)true);
            }
        } else {
            json.put("status", (Object)"DOWN").put("data", (Object)new JsonObject().put("cause", (Object)ar.cause().getMessage()));
        }
        return json;
    }

    public static JsonObject onError(String name, ProcedureException e) {
        JsonObject json = new JsonObject();
        if (name != null) {
            json.put("id", (Object)name);
        }
        return json.put("status", (Object)"DOWN").put("data", (Object)new JsonObject().put("procedure-execution-failure", (Object)true).put("cause", (Object)e.getMessage()));
    }

    public static boolean isUp(Future<JsonObject> json) {
        return !json.failed() && StatusHelper.isUp((JsonObject)json.result());
    }

    public static boolean isUp(JsonObject json) {
        return json == null || "UP".equals(json.getString("status")) || "UP".equals(json.getString("outcome"));
    }
}

