/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ParseUtils {
    public static Date parseHeaderDate(String value) {
        try {
            return ParseUtils.parseHttpDate(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parseWarningHeaderDate(String value) {
        int len;
        int index = value.indexOf(32);
        if (index > 0 && (index = value.indexOf(32, index + 1)) > 0 && (index = value.indexOf(32, index + 1)) > 0 && index + 2 < (len = value.length()) && value.charAt(index + 1) == '\"' && value.charAt(len - 1) == '\"') {
            String date = value.substring(index + 2, len - 1);
            try {
                return ParseUtils.parseHttpDate(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static SimpleDateFormat RFC_1123_DATE_TIME() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    }

    private static SimpleDateFormat RFC_850_DATE_TIME() {
        SimpleDateFormat format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    }

    private static SimpleDateFormat ASC_TIME() {
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    }

    public static String formatHttpDate(Date date) {
        return ParseUtils.RFC_1123_DATE_TIME().format(date);
    }

    public static Date parseHttpDate(String value) throws Exception {
        for (int sep = 0; sep < value.length(); ++sep) {
            char c = value.charAt(sep);
            if (c == ',') {
                String s = value.substring(0, sep);
                if (ParseUtils.parseWkday(s) != null) {
                    return ParseUtils.RFC_1123_DATE_TIME().parse(value);
                }
                if (ParseUtils.parseWeekday(s) != null) {
                    return ParseUtils.RFC_850_DATE_TIME().parse(value);
                }
                return null;
            }
            if (c != ' ') continue;
            String s = value.substring(0, sep);
            if (ParseUtils.parseWkday(s) != null) {
                return ParseUtils.ASC_TIME().parse(value);
            }
            return null;
        }
        return null;
    }

    private static DayOfWeek parseWkday(String value) {
        switch (value) {
            case "Mon": {
                return DayOfWeek.MONDAY;
            }
            case "Tue": {
                return DayOfWeek.TUESDAY;
            }
            case "Wed": {
                return DayOfWeek.WEDNESDAY;
            }
            case "Thu": {
                return DayOfWeek.THURSDAY;
            }
            case "Fri": {
                return DayOfWeek.FRIDAY;
            }
            case "Sat": {
                return DayOfWeek.SATURDAY;
            }
            case "Sun": {
                return DayOfWeek.SUNDAY;
            }
        }
        return null;
    }

    private static DayOfWeek parseWeekday(String value) {
        switch (value) {
            case "Monday": {
                return DayOfWeek.MONDAY;
            }
            case "Tuesday": {
                return DayOfWeek.TUESDAY;
            }
            case "Wednesday": {
                return DayOfWeek.WEDNESDAY;
            }
            case "Thursday": {
                return DayOfWeek.THURSDAY;
            }
            case "Friday": {
                return DayOfWeek.FRIDAY;
            }
            case "Saturday": {
                return DayOfWeek.SATURDAY;
            }
            case "Sunday": {
                return DayOfWeek.SUNDAY;
            }
        }
        return null;
    }
}

