/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.HttpProxy;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.BufferingReadStream;
import io.vertx.httpproxy.impl.BufferingWriteStream;
import io.vertx.httpproxy.impl.CacheControl;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.ParseUtils;
import io.vertx.httpproxy.impl.ProxyRequestImpl;
import io.vertx.httpproxy.impl.ProxyResponseImpl;
import io.vertx.httpproxy.impl.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class HttpProxyImpl
implements HttpProxy {
    private static final BiFunction<String, Resource, Resource> CACHE_GET_AND_VALIDATE = (key, resource) -> {
        long val = resource.timestamp + resource.maxAge;
        long now = System.currentTimeMillis();
        return val < now ? null : resource;
    };
    private final HttpClient client;
    private Function<HttpServerRequest, Future<SocketAddress>> selector = req -> Future.failedFuture((String)"No origin available");
    private final Map<String, Resource> cache = new HashMap<String, Resource>();

    public HttpProxyImpl(HttpClient client) {
        this.client = client;
    }

    @Override
    public HttpProxy originSelector(Function<HttpServerRequest, Future<SocketAddress>> selector) {
        this.selector = selector;
        return this;
    }

    @Override
    public void handle(HttpServerRequest outboundRequest) {
        this.handleProxyRequest(outboundRequest);
    }

    private Future<HttpClientRequest> resolveOrigin(HttpServerRequest outboundRequest) {
        return this.selector.apply(outboundRequest).flatMap(server -> {
            RequestOptions requestOptions = new RequestOptions();
            requestOptions.setServer(server);
            return this.client.request(requestOptions);
        });
    }

    boolean revalidateResource(ProxyResponse response, Resource resource) {
        if (resource.etag != null && response.etag() != null) {
            return resource.etag.equals(response.etag());
        }
        return true;
    }

    private void end(ProxyRequest proxyRequest, int sc) {
        proxyRequest.response().release().setStatusCode(sc).putHeader(HttpHeaders.CONTENT_LENGTH, "0").setBody(null).send();
    }

    private void handleProxyRequest(HttpServerRequest outboundRequest) {
        String cacheKey;
        Resource resource;
        ProxyRequestImpl proxyRequest = (ProxyRequestImpl)ProxyRequest.reverseProxy(outboundRequest);
        Boolean chunked = HttpUtils.isChunked(outboundRequest.headers());
        if (chunked == null) {
            this.end(proxyRequest, 400);
            return;
        }
        HttpMethod method = outboundRequest.method();
        if ((method == HttpMethod.GET || method == HttpMethod.HEAD) && (resource = this.cache.computeIfPresent(cacheKey = proxyRequest.absoluteURI(), CACHE_GET_AND_VALIDATE)) != null && this.tryHandleProxyRequestFromCache(proxyRequest, resource)) {
            return;
        }
        this.handleProxyRequestAndProxyResponse(proxyRequest);
    }

    private void handleProxyRequestAndProxyResponse(ProxyRequest proxyRequest) {
        this.handleProxyRequest(proxyRequest, (Handler<AsyncResult<ProxyResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.handleProxyResponse((ProxyResponse)ar.result(), (Handler<AsyncResult<Void>>)((Handler)ar2 -> {}));
            }
        }));
    }

    private void handleProxyRequest(ProxyRequest proxyRequest, Handler<AsyncResult<ProxyResponse>> handler) {
        Future<HttpClientRequest> f = this.resolveOrigin(proxyRequest.outboundRequest());
        f.onComplete(ar -> {
            if (ar.succeeded()) {
                this.handleProxyRequest(proxyRequest, (HttpClientRequest)ar.result(), handler);
            } else {
                HttpServerRequest outboundRequest = proxyRequest.outboundRequest();
                outboundRequest.resume();
                Promise promise = Promise.promise();
                outboundRequest.exceptionHandler(arg_0 -> ((Promise)promise).tryFail(arg_0));
                outboundRequest.endHandler(arg_0 -> ((Promise)promise).tryComplete(arg_0));
                promise.future().onComplete(ar2 -> this.end(proxyRequest, 502));
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void handleProxyRequest(ProxyRequest proxyRequest, HttpClientRequest inboundRequest, Handler<AsyncResult<ProxyResponse>> handler) {
        ((ProxyRequestImpl)proxyRequest).send(inboundRequest, (Handler<AsyncResult<ProxyResponse>>)((Handler)ar2 -> {
            if (ar2.succeeded()) {
                handler.handle(ar2);
            } else {
                proxyRequest.outboundRequest().response().setStatusCode(502).end();
                handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
            }
        }));
    }

    private void handleProxyResponse(ProxyResponse response, Handler<AsyncResult<Void>> completionHandler) {
        String contentLength;
        Boolean chunked = HttpUtils.isChunked(response.headers());
        if (chunked == null) {
            this.end(response.request(), 501);
            completionHandler.handle((Object)Future.failedFuture((String)"TODO"));
            return;
        }
        if (chunked.booleanValue() && response.request().version() == HttpVersion.HTTP_1_0 && (contentLength = response.headers().get(HttpHeaders.CONTENT_LENGTH)) == null) {
            Body body = response.getBody();
            response.release();
            BufferingWriteStream buffer = new BufferingWriteStream();
            body.stream().pipeTo((WriteStream)buffer, ar -> {
                if (ar.succeeded()) {
                    Buffer content = buffer.content();
                    response.setBody(Body.body(content));
                    this.continueHandleResponse(response, completionHandler);
                } else {
                    System.out.println("Not implemented");
                }
            });
            return;
        }
        this.continueHandleResponse(response, completionHandler);
    }

    private void continueHandleResponse(ProxyResponse response, Handler<AsyncResult<Void>> completionHandler) {
        Handler handler;
        ProxyRequest request = response.request();
        if (response.publicCacheControl() && response.maxAge() > 0L) {
            if (request.getMethod() == HttpMethod.GET) {
                String absoluteUri = request.absoluteURI();
                Resource res = new Resource(absoluteUri, response.getStatusCode(), response.getStatusMessage(), response.headers(), System.currentTimeMillis(), response.maxAge());
                response.bodyFilter(s -> new BufferingReadStream((ReadStream<Buffer>)s, res.content));
                handler = ar3 -> {
                    completionHandler.handle(ar3);
                    if (ar3.succeeded()) {
                        this.cache.put(absoluteUri, res);
                    }
                };
            } else {
                Resource resource;
                if (request.getMethod() == HttpMethod.HEAD && (resource = this.cache.get(request.absoluteURI())) != null && !this.revalidateResource(response, resource)) {
                    this.cache.remove(request.absoluteURI());
                }
                handler = completionHandler;
            }
        } else {
            handler = completionHandler;
        }
        ((ProxyResponseImpl)response).send(handler);
    }

    private boolean tryHandleProxyRequestFromCache(ProxyRequestImpl proxyRequest, Resource resource) {
        long now;
        long currentAge;
        CacheControl cacheControl;
        HttpServerRequest outboundRequest = proxyRequest.outboundRequest();
        String cacheControlHeader = outboundRequest.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControlHeader != null && (cacheControl = new CacheControl().parse(cacheControlHeader)).maxAge() >= 0 && (currentAge = (now = System.currentTimeMillis()) - resource.timestamp) > (long)(cacheControl.maxAge() * 1000)) {
            String etag = resource.headers.get(HttpHeaders.ETAG);
            if (etag != null) {
                proxyRequest.headers().set(HttpHeaders.IF_NONE_MATCH, (CharSequence)resource.etag);
                this.handleProxyRequest(proxyRequest, (Handler<AsyncResult<ProxyResponse>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        ProxyResponse proxyResp = (ProxyResponse)ar.result();
                        int sc = proxyResp.getStatusCode();
                        switch (sc) {
                            case 200: {
                                this.handleProxyResponse(proxyResp, (Handler<AsyncResult<Void>>)((Handler)ar2 -> {}));
                                break;
                            }
                            case 304: {
                                proxyResp.release();
                                resource.sendTo(proxyRequest.response());
                                break;
                            }
                            default: {
                                System.out.println("Not implemented");
                                break;
                            }
                        }
                    } else {
                        System.out.println("Not implemented");
                    }
                }));
                return true;
            }
            return false;
        }
        String ifModifiedSinceHeader = outboundRequest.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
        if ((outboundRequest.method() == HttpMethod.GET || outboundRequest.method() == HttpMethod.HEAD) && ifModifiedSinceHeader != null && resource.lastModified != null) {
            Date ifModifiedSince = ParseUtils.parseHeaderDate(ifModifiedSinceHeader);
            if (resource.lastModified.getTime() <= ifModifiedSince.getTime()) {
                outboundRequest.response().setStatusCode(304).end();
                return true;
            }
        }
        resource.sendTo(proxyRequest.response());
        return true;
    }
}

