/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.ProxyResponseImpl;
import java.util.function.Function;

public class ProxyRequestImpl
implements ProxyRequest {
    final ContextInternal context;
    private HttpMethod method;
    private HttpVersion version;
    private String uri;
    private String absoluteURI;
    private Body body;
    private MultiMap headers;
    HttpClientRequest inboundRequest;
    private HttpServerRequest outboundRequest;

    public ProxyRequestImpl(HttpServerRequest outboundRequest) {
        long contentLength = -1L;
        String contentLengthHeader = outboundRequest.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLengthHeader != null) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.method = outboundRequest.method();
        this.version = outboundRequest.version();
        this.body = Body.body((ReadStream<Buffer>)outboundRequest, contentLength);
        this.uri = outboundRequest.uri();
        this.headers = MultiMap.caseInsensitiveMultiMap().addAll(outboundRequest.headers());
        this.absoluteURI = outboundRequest.absoluteURI();
        this.outboundRequest = outboundRequest;
        this.context = (ContextInternal)((HttpServerRequestInternal)outboundRequest).context();
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public ProxyRequest setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public ProxyRequest setBody(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public String absoluteURI() {
        return this.absoluteURI;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public ProxyRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public HttpServerRequest outboundRequest() {
        return this.outboundRequest;
    }

    @Override
    public ProxyRequest release() {
        this.body.stream().resume();
        this.headers.clear();
        this.body = null;
        return this;
    }

    @Override
    public ProxyResponse response() {
        return new ProxyResponseImpl(this, this.outboundRequest.response());
    }

    void sendRequest(Handler<AsyncResult<ProxyResponse>> responseHandler) {
        this.inboundRequest.response().map(r -> {
            r.pause();
            return new ProxyResponseImpl(this, this.outboundRequest.response(), (HttpClientResponse)r);
        }).onComplete(responseHandler);
        this.inboundRequest.setMethod(this.method);
        this.inboundRequest.setURI(this.uri);
        this.headers.forEach(header -> {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            if (!name.equalsIgnoreCase("host")) {
                this.inboundRequest.headers().add(name, value);
            }
        });
        long len = this.body.length();
        if (len >= 0L) {
            this.inboundRequest.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(len));
        } else {
            this.inboundRequest.setChunked(true);
        }
        Pipe pipe = this.body.stream().pipe();
        pipe.endOnComplete(true);
        pipe.endOnFailure(false);
        pipe.to((WriteStream)this.inboundRequest, ar -> {
            if (ar.failed()) {
                this.inboundRequest.reset();
            }
        });
    }

    @Override
    public ProxyRequest putHeader(CharSequence name, CharSequence value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public ProxyRequest bodyFilter(Function<ReadStream<Buffer>, ReadStream<Buffer>> filter) {
        return this;
    }

    @Override
    public Future<ProxyResponse> send(HttpClientRequest inboundRequest) {
        PromiseInternal promise = this.context.promise();
        this.send(inboundRequest, (Handler<AsyncResult<ProxyResponse>>)promise);
        return promise.future();
    }

    void send(HttpClientRequest inboundRequest, Handler<AsyncResult<ProxyResponse>> completionHandler) {
        this.inboundRequest = inboundRequest;
        this.sendRequest(completionHandler);
    }
}

