/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;

public class BufferedReadStream
implements ReadStream<Buffer> {
    private long demand = 0L;
    private Handler<Void> endHandler;
    private Handler<Buffer> handler;
    private boolean ended = false;
    private final Buffer content;

    public BufferedReadStream() {
        this.content = Buffer.buffer();
    }

    public BufferedReadStream(Buffer content) {
        this.content = content;
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        this.handler = handler;
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.demand = 0L;
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.fetch(Long.MAX_VALUE);
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        if (!this.ended && amount > 0L) {
            this.ended = true;
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            if (this.handler != null && this.content.length() > 0) {
                this.handler.handle((Object)this.content);
            }
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }
}

