/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.httpproxy.HttpProxy;
import io.vertx.httpproxy.ProxyOptions;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.cache.CacheOptions;
import io.vertx.httpproxy.impl.BufferingReadStream;
import io.vertx.httpproxy.impl.CacheControl;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.ParseUtils;
import io.vertx.httpproxy.impl.ProxyRequestImpl;
import io.vertx.httpproxy.impl.ProxyResponseImpl;
import io.vertx.httpproxy.impl.Resource;
import io.vertx.httpproxy.spi.cache.Cache;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;

public class HttpProxyImpl
implements HttpProxy {
    private static final BiFunction<String, Resource, Resource> CACHE_GET_AND_VALIDATE = (key, resource) -> {
        long val = resource.timestamp + resource.maxAge;
        long now = System.currentTimeMillis();
        return val < now ? null : resource;
    };
    private final HttpClient client;
    private Function<HttpServerRequest, Future<SocketAddress>> selector = req -> Future.failedFuture((String)"No origin available");
    private final Cache<String, Resource> cache;

    public HttpProxyImpl(ProxyOptions options, HttpClient client) {
        CacheOptions cacheOptions = options.getCacheOptions();
        this.cache = cacheOptions != null ? cacheOptions.newCache() : null;
        this.client = client;
    }

    @Override
    public HttpProxy originSelector(Function<HttpServerRequest, Future<SocketAddress>> selector) {
        this.selector = selector;
        return this;
    }

    @Override
    public void handle(HttpServerRequest outboundRequest) {
        ProxyContext bh;
        ProxyRequest proxyRequest = ProxyRequest.reverseProxy(outboundRequest);
        Boolean chunked = HttpUtils.isChunked(outboundRequest.headers());
        if (chunked == null) {
            this.end(proxyRequest, 400);
            return;
        }
        if (this.cache != null) {
            Proxy logic = new Proxy();
            CachingFilter caching = new CachingFilter();
            caching.context = logic;
            logic.context = caching;
            bh = caching;
        } else {
            bh = new Proxy();
        }
        bh.handleProxyRequest(proxyRequest, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    private Future<HttpClientRequest> resolveOrigin(HttpServerRequest outboundRequest) {
        return this.selector.apply(outboundRequest).flatMap(server -> {
            RequestOptions requestOptions = new RequestOptions();
            requestOptions.setServer(server);
            return this.client.request(requestOptions);
        });
    }

    boolean revalidateResource(ProxyResponse response, Resource resource) {
        if (resource.etag != null && response.etag() != null) {
            return resource.etag.equals(response.etag());
        }
        return true;
    }

    private void end(ProxyRequest proxyRequest, int sc) {
        proxyRequest.response().release().setStatusCode(sc).putHeader(HttpHeaders.CONTENT_LENGTH, "0").setBody(null).send();
    }

    private class Proxy
    implements ProxyContext {
        private ProxyContext context = this;

        private Proxy() {
        }

        @Override
        public void handleProxyRequest(ProxyRequest request, Handler<AsyncResult<Void>> handler) {
            this.sendProxyRequest(request, (Handler<AsyncResult<ProxyResponse>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    this.sendProxyResponse((ProxyResponse)ar.result(), (Handler<AsyncResult<Void>>)((Handler)ar2 -> {}));
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        }

        private void sendProxyRequest(ProxyRequest proxyRequest, Handler<AsyncResult<ProxyResponse>> handler) {
            Future f = HttpProxyImpl.this.resolveOrigin(proxyRequest.outboundRequest());
            f.onComplete(ar -> {
                if (ar.succeeded()) {
                    this.sendProxyRequest(proxyRequest, (HttpClientRequest)ar.result(), handler);
                } else {
                    HttpServerRequest outboundRequest = proxyRequest.outboundRequest();
                    outboundRequest.resume();
                    Promise promise = Promise.promise();
                    outboundRequest.exceptionHandler(arg_0 -> ((Promise)promise).tryFail(arg_0));
                    outboundRequest.endHandler(arg_0 -> ((Promise)promise).tryComplete(arg_0));
                    promise.future().onComplete(ar2 -> HttpProxyImpl.this.end(proxyRequest, 502));
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        }

        private void sendProxyRequest(ProxyRequest proxyRequest, HttpClientRequest inboundRequest, Handler<AsyncResult<ProxyResponse>> handler) {
            ((ProxyRequestImpl)proxyRequest).send(inboundRequest, (Handler<AsyncResult<ProxyResponse>>)((Handler)ar2 -> {
                if (ar2.succeeded()) {
                    handler.handle(ar2);
                } else {
                    proxyRequest.outboundRequest().response().setStatusCode(502).end();
                    handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                }
            }));
        }

        private void sendProxyResponse(ProxyResponse response, Handler<AsyncResult<Void>> handler) {
            Boolean chunked = HttpUtils.isChunked(response.headers());
            if (chunked == null) {
                HttpProxyImpl.this.end(response.request(), 501);
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            this.context.handleProxyResponse(response, handler);
        }

        @Override
        public void handleProxyResponse(ProxyResponse response, Handler<AsyncResult<Void>> handler) {
            ((ProxyResponseImpl)response).send(handler);
        }
    }

    private class CachingFilter
    implements ProxyContext {
        private ProxyContext context;
        private Resource cached;

        private CachingFilter() {
        }

        @Override
        public void handleProxyRequest(ProxyRequest request, Handler<AsyncResult<Void>> handler) {
            if (this.tryHandleProxyRequestFromCache(request, handler)) {
                return;
            }
            this.context.handleProxyRequest(request, handler);
        }

        @Override
        public void handleProxyResponse(ProxyResponse response, Handler<AsyncResult<Void>> handler) {
            this.sendAndTryCacheProxyResponse(response, handler);
        }

        private void sendAndTryCacheProxyResponse(ProxyResponse response, Handler<AsyncResult<Void>> completionHandler) {
            Handler handler;
            if (this.cached != null && response.getStatusCode() == 304) {
                response.release();
                this.cached.sendTo(response.request().response());
                completionHandler.handle((Object)Future.succeededFuture());
                return;
            }
            ProxyRequest request = response.request();
            if (response.publicCacheControl() && response.maxAge() > 0L) {
                if (request.getMethod() == HttpMethod.GET) {
                    String absoluteUri = request.absoluteURI();
                    Resource res = new Resource(absoluteUri, response.getStatusCode(), response.getStatusMessage(), response.headers(), System.currentTimeMillis(), response.maxAge());
                    response.bodyFilter(s -> new BufferingReadStream((ReadStream<Buffer>)s, res.content));
                    handler = ar3 -> {
                        if (ar3.succeeded()) {
                            HttpProxyImpl.this.cache.put(absoluteUri, res);
                        }
                        completionHandler.handle(ar3);
                    };
                } else {
                    Resource resource;
                    if (request.getMethod() == HttpMethod.HEAD && (resource = (Resource)HttpProxyImpl.this.cache.get(request.absoluteURI())) != null && !HttpProxyImpl.this.revalidateResource(response, resource)) {
                        HttpProxyImpl.this.cache.remove(request.absoluteURI());
                    }
                    handler = completionHandler;
                }
            } else {
                handler = completionHandler;
            }
            this.context.handleProxyResponse(response, handler);
        }

        private boolean tryHandleProxyRequestFromCache(ProxyRequest proxyRequest, Handler<AsyncResult<Void>> handler) {
            long now;
            long currentAge;
            CacheControl cacheControl;
            Resource resource;
            HttpServerRequest outboundRequest = proxyRequest.outboundRequest();
            HttpMethod method = outboundRequest.method();
            if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
                String cacheKey = proxyRequest.absoluteURI();
                resource = (Resource)HttpProxyImpl.this.cache.computeIfPresent(cacheKey, CACHE_GET_AND_VALIDATE);
                if (resource == null) {
                    return false;
                }
            } else {
                return false;
            }
            String cacheControlHeader = outboundRequest.getHeader(HttpHeaders.CACHE_CONTROL);
            if (cacheControlHeader != null && (cacheControl = new CacheControl().parse(cacheControlHeader)).maxAge() >= 0 && (currentAge = (now = System.currentTimeMillis()) - resource.timestamp) > (long)(cacheControl.maxAge() * 1000)) {
                String etag = resource.headers.get(HttpHeaders.ETAG);
                if (etag != null) {
                    proxyRequest.headers().set(HttpHeaders.IF_NONE_MATCH, (CharSequence)resource.etag);
                    this.cached = resource;
                    this.context.handleProxyRequest(proxyRequest, handler);
                    return true;
                }
                return false;
            }
            String ifModifiedSinceHeader = outboundRequest.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
            if ((outboundRequest.method() == HttpMethod.GET || outboundRequest.method() == HttpMethod.HEAD) && ifModifiedSinceHeader != null && resource.lastModified != null) {
                Date ifModifiedSince = ParseUtils.parseHeaderDate(ifModifiedSinceHeader);
                if (resource.lastModified.getTime() <= ifModifiedSince.getTime()) {
                    outboundRequest.response().setStatusCode(304).end();
                    handler.handle((Object)Future.succeededFuture());
                    return true;
                }
            }
            resource.sendTo(proxyRequest.response());
            handler.handle((Object)Future.succeededFuture());
            return true;
        }
    }

    private static interface ProxyContext {
        public void handleProxyRequest(ProxyRequest var1, Handler<AsyncResult<Void>> var2);

        public void handleProxyResponse(ProxyResponse var1, Handler<AsyncResult<Void>> var2);
    }
}

