/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.ReadStream;
import io.vertx.httpproxy.HttpProxy;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyOptions;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.cache.CacheOptions;
import io.vertx.httpproxy.impl.CachingFilter;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.ProxiedRequest;
import io.vertx.httpproxy.impl.ProxiedResponse;
import io.vertx.httpproxy.impl.Resource;
import io.vertx.httpproxy.spi.cache.Cache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class ReverseProxy
implements HttpProxy {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxy.class);
    private final HttpClient client;
    private final boolean supportWebSocket;
    private BiFunction<HttpServerRequest, HttpClient, Future<HttpClientRequest>> selector = (req, client) -> Future.failedFuture((String)"No origin available");
    private final List<ProxyInterceptorEntry> interceptors = new ArrayList<ProxyInterceptorEntry>();

    public ReverseProxy(ProxyOptions options, HttpClient client2) {
        CacheOptions cacheOptions = options.getCacheOptions();
        if (cacheOptions != null) {
            Cache<String, Resource> cache = cacheOptions.newCache();
            this.addInterceptor(new CachingFilter(cache));
        }
        this.client = client2;
        this.supportWebSocket = options.getSupportWebSocket();
    }

    @Override
    public HttpProxy originRequestProvider(BiFunction<HttpServerRequest, HttpClient, Future<HttpClientRequest>> provider) {
        this.selector = provider;
        return this;
    }

    @Override
    public HttpProxy addInterceptor(ProxyInterceptor interceptor, boolean supportsWebSocketUpgrade) {
        this.interceptors.add(new ProxyInterceptorEntry(Objects.requireNonNull(interceptor), supportsWebSocketUpgrade));
        return this;
    }

    @Override
    public void handle(HttpServerRequest request) {
        ProxyRequest proxyRequest = ProxyRequest.reverseProxy(request);
        Boolean chunked = HttpUtils.isChunked(request.headers());
        if (chunked == null) {
            this.end(proxyRequest, 400);
            return;
        }
        boolean isWebSocket = this.supportWebSocket && request.canUpgradeToWebSocket();
        Proxy proxy = new Proxy(proxyRequest, isWebSocket);
        proxy.sendRequest().recover(throwable -> {
            log.trace((Object)"Error in sending the request", throwable);
            return Future.succeededFuture((Object)proxyRequest.release().response().setStatusCode(502));
        }).compose(x$0 -> proxy.sendProxyResponse((ProxyResponse)x$0)).recover(throwable -> {
            log.trace((Object)"Error in sending the response", throwable);
            return proxy.response().release().setStatusCode(502).send();
        });
    }

    private void end(ProxyRequest proxyRequest, int sc) {
        proxyRequest.response().release().setStatusCode(sc).putHeader(HttpHeaders.CONTENT_LENGTH, "0").setBody(null).send();
    }

    private Future<HttpClientRequest> resolveOrigin(HttpServerRequest proxiedRequest) {
        return this.selector.apply(proxiedRequest, this.client);
    }

    private static class ProxyInterceptorEntry {
        final ProxyInterceptor interceptor;
        final boolean supportsWebSocketUpgrade;

        ProxyInterceptorEntry(ProxyInterceptor interceptor, boolean supportsWebSocketUpgrade) {
            this.interceptor = interceptor;
            this.supportsWebSocketUpgrade = supportsWebSocketUpgrade;
        }
    }

    private class Proxy
    implements ProxyContext {
        private final ProxyRequest request;
        private ProxyResponse response;
        private final Map<String, Object> attachments = new HashMap<String, Object>();
        private final ListIterator<ProxyInterceptorEntry> filters;
        private final boolean isWebSocket;

        private Proxy(ProxyRequest request, boolean isWebSocket) {
            this.request = request;
            this.isWebSocket = isWebSocket;
            this.filters = ReverseProxy.this.interceptors.listIterator();
        }

        @Override
        public boolean isWebSocket() {
            return this.isWebSocket;
        }

        @Override
        public void set(String name, Object value) {
            this.attachments.put(name, value);
        }

        @Override
        public <T> T get(String name, Class<T> type) {
            Object o = this.attachments.get(name);
            return type.isInstance(o) ? (T)type.cast(o) : null;
        }

        @Override
        public ProxyRequest request() {
            return this.request;
        }

        @Override
        public Future<ProxyResponse> sendRequest() {
            if (this.filters.hasNext()) {
                ProxyInterceptorEntry next = this.filters.next();
                if (this.isWebSocket && !next.supportsWebSocketUpgrade) {
                    return this.sendRequest();
                }
                return next.interceptor.handleProxyRequest(this);
            }
            if (this.isWebSocket) {
                HttpServerRequest proxiedRequest = this.request().proxiedRequest();
                return ReverseProxy.this.resolveOrigin(proxiedRequest).compose(request -> {
                    request.setMethod(this.request().getMethod());
                    request.setURI(this.request().getURI());
                    request.headers().addAll(this.request().headers()).set(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE);
                    Future responseFuture = request.connect();
                    ReadStream<Buffer> readStream = this.request().getBody().stream();
                    readStream.handler(arg_0 -> ((HttpClientRequest)request).write(arg_0));
                    readStream.resume();
                    proxiedRequest.resume();
                    return responseFuture;
                }).map(response -> new ProxiedResponse((ProxiedRequest)this.request(), this.request().proxiedRequest().response(), (HttpClientResponse)response));
            }
            return this.sendProxyRequest(this.request);
        }

        @Override
        public ProxyResponse response() {
            return this.response;
        }

        @Override
        public Future<Void> sendResponse() {
            if (this.filters.hasPrevious()) {
                ProxyInterceptorEntry previous = this.filters.previous();
                if (this.isWebSocket && !previous.supportsWebSocketUpgrade) {
                    return this.sendResponse();
                }
                return previous.interceptor.handleProxyResponse(this);
            }
            if (this.isWebSocket) {
                HttpClientResponse proxiedResponse = this.response().proxiedResponse();
                if (this.response.getStatusCode() == 101) {
                    HttpServerResponse clientResponse = this.request().proxiedRequest().response();
                    clientResponse.setStatusCode(101);
                    clientResponse.headers().addAll(this.response.headers());
                    Future otherso = this.request.proxiedRequest().toNetSocket();
                    otherso.onComplete(ar3 -> {
                        if (ar3.succeeded()) {
                            NetSocket responseSocket = (NetSocket)ar3.result();
                            NetSocket proxyResponseSocket = proxiedResponse.netSocket();
                            responseSocket.handler(arg_0 -> ((NetSocket)proxyResponseSocket).write(arg_0));
                            proxyResponseSocket.handler(arg_0 -> ((NetSocket)responseSocket).write(arg_0));
                            responseSocket.closeHandler(v -> proxyResponseSocket.close());
                            proxyResponseSocket.closeHandler(v -> responseSocket.close());
                        } else {
                            System.err.println("Handle this case");
                            ar3.cause().printStackTrace();
                        }
                    });
                } else {
                    this.request().proxiedRequest().resume();
                    ReverseProxy.this.end(this.request(), proxiedResponse.statusCode());
                }
                return Future.succeededFuture();
            }
            return this.response.send();
        }

        private Future<ProxyResponse> sendProxyRequest(ProxyRequest proxyRequest) {
            return ReverseProxy.this.resolveOrigin(proxyRequest.proxiedRequest()).compose(proxyRequest::send);
        }

        private Future<Void> sendProxyResponse(ProxyResponse response) {
            this.response = response;
            Boolean chunked = HttpUtils.isChunked(response.headers());
            if (chunked == null) {
                ReverseProxy.this.end(response.request(), 501);
                return Future.succeededFuture();
            }
            return this.sendResponse();
        }
    }
}

