/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.interceptors.impl;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.BufferingWriteStream;
import java.util.Objects;
import java.util.function.Function;

public class BodyInterceptorImpl
implements ProxyInterceptor {
    private final Function<Buffer, Buffer> modifyRequestBody;
    private final Function<Buffer, Buffer> modifyResponseBody;
    private static final Function<Buffer, Buffer> NO_OP = buffer -> buffer;

    public BodyInterceptorImpl(Function<Buffer, Buffer> modifyRequestBody, Function<Buffer, Buffer> modifyResponseBody) {
        this.modifyRequestBody = Objects.requireNonNullElse(modifyRequestBody, NO_OP);
        this.modifyResponseBody = Objects.requireNonNullElse(modifyResponseBody, NO_OP);
    }

    @Override
    public Future<ProxyResponse> handleProxyRequest(ProxyContext context) {
        Body body = context.request().getBody();
        BufferingWriteStream bws = new BufferingWriteStream();
        return body.stream().pipeTo((WriteStream)bws).compose(r -> {
            context.request().setBody(Body.body(this.modifyRequestBody.apply(bws.content())));
            return context.sendRequest();
        });
    }

    @Override
    public Future<Void> handleProxyResponse(ProxyContext context) {
        Body body = context.response().getBody();
        BufferingWriteStream bws = new BufferingWriteStream();
        return body.stream().pipeTo((WriteStream)bws).compose(r -> {
            context.response().setBody(Body.body(this.modifyResponseBody.apply(bws.content())));
            return context.sendResponse();
        });
    }
}

