/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.interceptors.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.httpproxy.interceptors.HeadInterceptor;
import io.vertx.httpproxy.interceptors.HeadInterceptorBuilder;
import io.vertx.httpproxy.interceptors.impl.HeadInterceptorImpl;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HeadInterceptorBuilderImpl
implements HeadInterceptorBuilder {
    private final Stream.Builder<Handler<MultiMap>> queryUpdaters = Stream.builder();
    private final Stream.Builder<Function<String, String>> pathUpdaters = Stream.builder();
    private final Stream.Builder<Handler<MultiMap>> requestHeadersUpdaters = Stream.builder();
    private final Stream.Builder<Handler<MultiMap>> responseHeadersUpdaters = Stream.builder();

    @Override
    public HeadInterceptor build() {
        return new HeadInterceptorImpl(this.queryUpdaters.build().collect(Collectors.toUnmodifiableList()), this.pathUpdaters.build().collect(Collectors.toUnmodifiableList()), this.requestHeadersUpdaters.build().collect(Collectors.toUnmodifiableList()), this.responseHeadersUpdaters.build().collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public HeadInterceptorBuilder updatingQueryParams(Handler<MultiMap> updater) {
        if (updater != null) {
            this.queryUpdaters.add(updater);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder settingQueryParam(String name, String value) {
        if (name != null && value != null) {
            return this.updatingQueryParams((Handler<MultiMap>)((Handler)map -> map.set(name, value)));
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder removingQueryParam(String name) {
        if (name != null) {
            return this.updatingQueryParams((Handler<MultiMap>)((Handler)map -> map.remove(name)));
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder updatingPath(Function<String, String> mutator) {
        if (mutator != null) {
            this.pathUpdaters.add(mutator);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder addingPathPrefix(String prefix) {
        if (prefix != null) {
            return this.updatingPath(path -> prefix + path);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder removingPathPrefix(String prefix) {
        if (prefix != null) {
            return this.updatingPath(path -> path.startsWith(prefix) ? path.substring(prefix.length()) : path);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder updatingRequestHeaders(Handler<MultiMap> requestHeadersUpdater) {
        if (requestHeadersUpdater != null) {
            this.requestHeadersUpdaters.add(requestHeadersUpdater);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder updatingResponseHeaders(Handler<MultiMap> responseHeadersUpdater) {
        if (responseHeadersUpdater != null) {
            this.responseHeadersUpdaters.add(responseHeadersUpdater);
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder filteringRequestHeaders(Set<CharSequence> forbiddenRequestHeaders) {
        if (forbiddenRequestHeaders != null) {
            return this.updatingRequestHeaders((Handler<MultiMap>)((Handler)headers -> {
                for (CharSequence cs : forbiddenRequestHeaders) {
                    headers.remove(cs);
                }
            }));
        }
        return this;
    }

    @Override
    public HeadInterceptorBuilder filteringResponseHeaders(Set<CharSequence> forbiddenResponseHeaders) {
        if (forbiddenResponseHeaders != null) {
            return this.updatingResponseHeaders((Handler<MultiMap>)((Handler)headers -> {
                for (CharSequence cs : forbiddenResponseHeaders) {
                    headers.remove(cs);
                }
            }));
        }
        return this;
    }
}

