/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Future;
import io.vertx.httpproxy.cache.CacheOptions;
import io.vertx.httpproxy.spi.cache.Cache;
import io.vertx.httpproxy.spi.cache.Resource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CacheImpl
implements Cache {
    private final int maxSize;
    private final Map<String, Resource> data;

    public CacheImpl(CacheOptions options) {
        this.maxSize = options.getMaxSize();
        this.data = Collections.synchronizedMap(new LinkedHashMap<String, Resource>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Resource> eldest) {
                return this.size() > CacheImpl.this.maxSize;
            }
        });
    }

    @Override
    public Future<Void> put(String key, Resource value) {
        this.data.put(key, value);
        return Future.succeededFuture();
    }

    @Override
    public Future<Resource> get(String key) {
        return Future.succeededFuture((Object)this.data.get(key));
    }

    @Override
    public Future<Void> remove(String key) {
        this.data.remove(key);
        return Future.succeededFuture();
    }
}

