/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.interceptors.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.interceptors.HeadInterceptor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

class HeadInterceptorImpl
implements HeadInterceptor {
    private final List<Handler<MultiMap>> queryUpdaters;
    private final List<Function<String, String>> pathUpdaters;
    private final List<Handler<MultiMap>> requestHeadersUpdaters;
    private final List<Handler<MultiMap>> responseHeadersUpdaters;

    HeadInterceptorImpl(List<Handler<MultiMap>> queryUpdaters, List<Function<String, String>> pathUpdaters, List<Handler<MultiMap>> requestHeadersUpdaters, List<Handler<MultiMap>> responseHeadersUpdaters) {
        this.queryUpdaters = Objects.requireNonNull(queryUpdaters);
        this.pathUpdaters = Objects.requireNonNull(pathUpdaters);
        this.requestHeadersUpdaters = Objects.requireNonNull(requestHeadersUpdaters);
        this.responseHeadersUpdaters = Objects.requireNonNull(responseHeadersUpdaters);
    }

    @Override
    public Future<ProxyResponse> handleProxyRequest(ProxyContext context) {
        this.queryHandleProxyRequest(context);
        this.pathHandleProxyRequest(context);
        this.headersHandleProxyRequest(context);
        return context.sendRequest();
    }

    @Override
    public Future<Void> handleProxyResponse(ProxyContext context) {
        this.headersHandleProxyResponse(context);
        return context.sendResponse();
    }

    private void queryHandleProxyRequest(ProxyContext context) {
        String rawUri = context.request().getURI();
        MultiMap params = HeadInterceptorImpl.queryParams(rawUri);
        String cleanedUri = HeadInterceptorImpl.cleanedUri(rawUri);
        for (Handler<MultiMap> queryUpdater : this.queryUpdaters) {
            queryUpdater.handle((Object)params);
        }
        String newUri = HeadInterceptorImpl.buildUri(cleanedUri, params);
        context.request().setURI(newUri);
    }

    private static MultiMap queryParams(String uri) {
        MultiMap queryParams = MultiMap.caseInsensitiveMultiMap();
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            QueryStringDecoder dec = new QueryStringDecoder(uri);
            dec.parameters().forEach((arg_0, arg_1) -> ((MultiMap)queryParams).add(arg_0, arg_1));
        }
        return queryParams;
    }

    private static String cleanedUri(String uri) {
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    private static String buildUri(String uri, MultiMap queryParams) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        QueryStringEncoder encoder = new QueryStringEncoder(decoder.rawPath());
        decoder.parameters().forEach((name, values) -> {
            for (String value : values) {
                encoder.addParam(name, value);
            }
        });
        queryParams.forEach(param -> encoder.addParam((String)param.getKey(), (String)param.getValue()));
        uri = encoder.toString();
        return uri;
    }

    private void pathHandleProxyRequest(ProxyContext context) {
        ProxyRequest proxyRequest = context.request();
        for (Function<String, String> pathUpdater : this.pathUpdaters) {
            proxyRequest.setURI(pathUpdater.apply(proxyRequest.getURI()));
        }
    }

    private void headersHandleProxyRequest(ProxyContext context) {
        ProxyRequest request = context.request();
        for (Handler<MultiMap> requestHeadersUpdater : this.requestHeadersUpdaters) {
            requestHeadersUpdater.handle((Object)request.headers());
        }
    }

    private void headersHandleProxyResponse(ProxyContext context) {
        ProxyResponse response = context.response();
        for (Handler<MultiMap> responseHeadersUpdater : this.responseHeadersUpdaters) {
            responseHeadersUpdater.handle((Object)response.headers());
        }
    }
}

