/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.httpservicefactory;

import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.ext.httpservicefactory.PGPHelper;
import io.vertx.ext.httpservicefactory.ValidationPolicy;
import io.vertx.service.ServiceVerticleFactory;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;

public class HttpServiceFactory
extends ServiceVerticleFactory {
    public static final String CACHE_DIR_PROPERTY = "vertx.httpServiceFactory.cacheDir";
    public static final String HTTP_CLIENT_OPTIONS_PROPERTY = "vertx.httpServiceFactory.httpClientOptions";
    public static final String HTTPS_CLIENT_OPTIONS_PROPERTY = "vertx.httpServiceFactory.httpsClientOptions";
    public static final String AUTH_USERNAME_PROPERTY = "vertx.httpServiceFactory.authUsername";
    public static final String AUTH_PASSWORD_PROPERTY = "vertx.httpServiceFactory.authPassword";
    public static final String PROXY_HOST_PROPERTY = "vertx.httpServiceFactory.proxyHost";
    public static final String PROXY_PORT_PROPERTY = "vertx.httpServiceFactory.proxyPort";
    public static final String KEYSERVER_URI_TEMPLATE = "vertx.httpServiceFactory.keyserverURITemplate";
    public static final String VALIDATION_POLICY = "vertx.httpServiceFactory.validationPolicy";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String FILE_CACHE_DIR = ".vertx" + FILE_SEP + "vertx-http-service-factory";
    private Vertx vertx;
    private File cacheDir;
    private String username;
    private String password;
    private String keyserverURITemplate;
    private ValidationPolicy validationPolicy;
    private HttpClientOptions options;

    public void init(Vertx vertx) {
        this.cacheDir = new File(System.getProperty(CACHE_DIR_PROPERTY, FILE_CACHE_DIR));
        this.validationPolicy = ValidationPolicy.valueOf(System.getProperty(VALIDATION_POLICY, ValidationPolicy.VERIFY.toString()).toUpperCase());
        this.username = System.getProperty(AUTH_USERNAME_PROPERTY);
        this.password = System.getProperty(AUTH_PASSWORD_PROPERTY);
        this.options = this.configOptions();
        this.keyserverURITemplate = System.getProperty(KEYSERVER_URI_TEMPLATE, "http://pool.sks-keyservers.net:11371/pks/lookup?op=get&options=mr&search=0x%016X");
        this.vertx = vertx;
    }

    protected HttpClientOptions createHttpClientOptions(String scheme) {
        HttpClientOptions options;
        String optionsJson;
        if ("https".equals(scheme)) {
            optionsJson = System.getProperty(HTTPS_CLIENT_OPTIONS_PROPERTY);
            options = optionsJson != null ? new HttpClientOptions(new JsonObject(optionsJson)) : this.createHttpClientOptions("http").setTrustAll(true);
            options.setSsl(true);
        } else {
            optionsJson = System.getProperty(HTTP_CLIENT_OPTIONS_PROPERTY);
            options = optionsJson != null ? new HttpClientOptions(new JsonObject(optionsJson)) : new HttpClientOptions();
        }
        String proxyHost = System.getProperty(PROXY_HOST_PROPERTY);
        int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT_PROPERTY, "-1"));
        if (proxyHost != null) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost).setType(ProxyType.HTTP);
            if (proxyPort > 0) {
                proxyOptions.setPort(proxyPort);
            }
            options.setProxyOptions(proxyOptions);
        }
        return options;
    }

    protected HttpClientOptions configOptions() {
        return this.createHttpClientOptions(this.prefix());
    }

    public String prefix() {
        return "http";
    }

    public void resolve(String identifier, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<String> resolution) {
        String signatureKey;
        String deploymentKey;
        URI signatureURL;
        URI url;
        String serviceName;
        String stringURL;
        int pos = identifier.lastIndexOf("::");
        if (pos != -1) {
            stringURL = identifier.substring(0, pos);
            serviceName = identifier.substring(pos + 2);
        } else {
            serviceName = null;
            stringURL = identifier;
        }
        try {
            url = new URI(stringURL);
            signatureURL = new URI(url.getScheme(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath() + ".asc", url.getQuery(), url.getFragment());
            deploymentKey = URLEncoder.encode(url.toString(), "UTF-8");
            signatureKey = URLEncoder.encode(signatureURL.toString(), "UTF-8");
        }
        catch (Exception e) {
            resolution.fail((Throwable)e);
            return;
        }
        File deploymentFile = new File(this.cacheDir, deploymentKey);
        File signatureFile = new File(this.cacheDir, signatureKey);
        HttpClient client = this.vertx.createHttpClient(this.options);
        this.doRequest(client, deploymentFile, url, signatureFile, signatureURL, (Handler<AsyncResult<Result>>)((Handler)ar -> {
            if (ar.succeeded()) {
                if (((Result)ar.result()).signature != null) {
                    HttpClient keyserverClient;
                    File publicKeyFile;
                    URI publicKeyURI;
                    PGPSignature signature;
                    try {
                        signature = PGPHelper.getSignature(Files.readAllBytes(((Result)ar.result()).signature.toPath()));
                        String uri = String.format(this.keyserverURITemplate, signature.getKeyID());
                        publicKeyURI = new URI(uri);
                        publicKeyFile = new File(this.cacheDir, URLEncoder.encode(publicKeyURI.toString(), "UTF-8"));
                    }
                    catch (Exception e) {
                        this.closeQuietly(client);
                        resolution.fail((Throwable)e);
                        return;
                    }
                    if (!publicKeyURI.getScheme().equals(this.prefix())) {
                        this.closeQuietly(client);
                        keyserverClient = this.vertx.createHttpClient(this.createHttpClientOptions(publicKeyURI.getScheme()));
                    } else {
                        keyserverClient = client;
                    }
                    BiFunction<String, Buffer, Buffer> unmarshallerFactory = (mediaType, buf) -> {
                        switch (mediaType) {
                            case "application/json": {
                                JsonObject json = new JsonObject(buf.toString());
                                return Buffer.buffer((String)json.getJsonArray("keys").getJsonObject(0).getString("bundle"));
                            }
                        }
                        return buf;
                    };
                    this.doRequest(keyserverClient, publicKeyFile, publicKeyURI, null, null, false, unmarshallerFactory, (Handler<AsyncResult<File>>)((Handler)ar2 -> {
                        if (ar2.succeeded()) {
                            try {
                                FileInputStream f;
                                boolean verified;
                                long keyID = signature.getKeyID();
                                File file = (File)ar2.result();
                                Path path = file.toPath();
                                PGPPublicKey publicKey = PGPHelper.getPublicKey(Files.readAllBytes(path), keyID);
                                if (publicKey != null && (verified = PGPHelper.verifySignature(f = new FileInputStream(((Result)ar.result()).deployment), new FileInputStream(((Result)ar.result()).signature), publicKey))) {
                                    this.deploy(deploymentFile, identifier, serviceName, deploymentOptions, classLoader, resolution);
                                    return;
                                }
                                resolution.fail((Throwable)new Exception("Signature verification failed"));
                            }
                            catch (Exception e) {
                                resolution.fail((Throwable)e);
                            }
                            finally {
                                this.closeQuietly(keyserverClient);
                            }
                        } else {
                            this.closeQuietly(keyserverClient);
                            resolution.fail(ar2.cause());
                        }
                    }));
                } else {
                    this.closeQuietly(client);
                    this.deploy(deploymentFile, identifier, serviceName, deploymentOptions, classLoader, resolution);
                }
            } else {
                resolution.fail(ar.cause());
            }
        }));
    }

    private void doRequest(HttpClient client, File file, URI url, String username, String password, boolean doAuth, BiFunction<String, Buffer, Buffer> unmarshaller, Handler<AsyncResult<File>> handler) {
        int port;
        if (file.exists() && file.isFile()) {
            handler.handle((Object)Future.succeededFuture((Object)file));
            return;
        }
        String requestURI = url.getPath();
        if (url.getQuery() != null) {
            requestURI = requestURI + "?" + url.getQuery();
        }
        if ((port = url.getPort()) == -1) {
            port = "http".equals(url.getScheme()) ? 80 : 443;
        }
        HttpClientRequest req = client.get(port, url.getHost(), requestURI, ar -> {
            if (ar.succeeded()) {
                HttpClientResponse resp = (HttpClientResponse)ar.result();
                int status = resp.statusCode();
                switch (resp.statusCode()) {
                    case 200: {
                        String contentType = resp.getHeader("Content-Type");
                        int index = contentType.indexOf(";");
                        String mediaType = index > -1 ? contentType.substring(0, index) : contentType;
                        AtomicBoolean done = new AtomicBoolean();
                        resp.exceptionHandler(err -> {
                            if (done.compareAndSet(false, true)) {
                                handler.handle((Object)Future.failedFuture((Throwable)err));
                            }
                        });
                        resp.bodyHandler(body -> {
                            Buffer data;
                            if (!done.compareAndSet(false, true)) {
                                return;
                            }
                            File parentFile = file.getParentFile();
                            if (!parentFile.exists()) {
                                parentFile.mkdirs();
                            }
                            try {
                                data = (Buffer)unmarshaller.apply(mediaType, (Buffer)body);
                            }
                            catch (Exception e) {
                                handler.handle((Object)Future.failedFuture((Throwable)e));
                                return;
                            }
                            this.vertx.fileSystem().open(file.getPath(), new OpenOptions().setCreate(true), ar2 -> {
                                if (ar2.succeeded()) {
                                    AsyncFile result = (AsyncFile)ar2.result();
                                    result.write((Object)data);
                                    result.close(v2 -> {
                                        if (v2.succeeded()) {
                                            handler.handle((Object)Future.succeededFuture((Object)file));
                                        } else {
                                            handler.handle((Object)Future.failedFuture((Throwable)v2.cause()));
                                        }
                                    });
                                } else {
                                    handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                                }
                            });
                        });
                        break;
                    }
                    case 401: {
                        if (this.prefix().equals("https") && resp.getHeader("WWW-Authenticate") != null && username != null && password != null) {
                            this.doRequest(client, file, url, username, password, true, unmarshaller, handler);
                            return;
                        }
                        handler.handle((Object)Future.failedFuture((Throwable)new Exception("Unauthorized")));
                        break;
                    }
                    default: {
                        handler.handle((Object)Future.failedFuture((Throwable)new Exception("Cannot get file status:" + status)));
                        break;
                    }
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        req.setFollowRedirects(true);
        if (doAuth && username != null && password != null) {
            req.putHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        }
        req.putHeader("user-agent", "Vert.x Http Service Factory");
        req.end();
    }

    protected void doRequest(HttpClient client, File file, URI url, File signatureFile, URI signatureURL, Handler<AsyncResult<Result>> handler) {
        this.doRequest(client, file, url, this.username, this.password, false, (mediatype, buf) -> buf, (Handler<AsyncResult<File>>)((Handler)ar1 -> {
            if (ar1.succeeded()) {
                if (this.validationPolicy != ValidationPolicy.NONE) {
                    this.doRequest(client, signatureFile, signatureURL, this.username, this.password, false, (mediatype, buf) -> buf, (Handler<AsyncResult<File>>)((Handler)ar3 -> {
                        if (ar3.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)new Result((File)ar1.result(), (File)ar3.result())));
                        } else if (this.validationPolicy == ValidationPolicy.MANDATORY) {
                            handler.handle((Object)Future.failedFuture((Throwable)ar3.cause()));
                        } else {
                            handler.handle((Object)Future.succeededFuture((Object)new Result((File)ar1.result(), null)));
                        }
                    }));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)new Result(file, null)));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar1.cause()));
            }
        }));
    }

    private void deploy(File file, String identifier, String serviceName, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<String> resolution) {
        try {
            String serviceIdentifer = null;
            if (serviceName == null) {
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    serviceIdentifer = (String)manifest.getMainAttributes().get(new Attributes.Name("Main-Verticle"));
                }
            } else {
                serviceIdentifer = "service:" + serviceName;
            }
            if (serviceIdentifer == null) {
                throw new IllegalArgumentException("Invalid service identifier, missing service name: " + identifier);
            }
            deploymentOptions.setExtraClasspath(Collections.singletonList(file.getAbsolutePath()));
            deploymentOptions.setIsolationGroup("__vertx_maven_" + file.getName());
            URLClassLoader urlc = new URLClassLoader(new URL[]{file.toURI().toURL()}, classLoader);
            super.resolve(serviceIdentifer, deploymentOptions, (ClassLoader)urlc, resolution);
        }
        catch (Exception e) {
            resolution.fail((Throwable)e);
        }
    }

    private void closeQuietly(HttpClient client) {
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Result {
        final File deployment;
        final File signature;

        public Result(File deployment, File signature) {
            this.deployment = deployment;
            this.signature = signature;
        }
    }
}

