/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.ignite.impl.ClusterSerializationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class AsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final IgniteCache<K, V> cache;

    public AsyncMapImpl(IgniteCache<K, V> cache, Vertx vertx) {
        this.cache = cache;
        this.vertx = vertx;
    }

    public void get(K key, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAsync(ClusterSerializationUtils.marshal(key)), handler);
    }

    public void put(K key, V value, Handler<AsyncResult<Void>> handler) {
        this.execute(cache -> cache.putAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler);
    }

    public void put(K key, V value, long ttl, Handler<AsyncResult<Void>> handler) {
        this.executeWithTtl(cache -> cache.putAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler, ttl);
    }

    public void putIfAbsent(K key, V value, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndPutIfAbsentAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler);
    }

    public void putIfAbsent(K key, V value, long ttl, Handler<AsyncResult<V>> handler) {
        this.executeWithTtl(cache -> cache.getAndPutIfAbsentAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler, ttl);
    }

    public void remove(K key, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndRemoveAsync(ClusterSerializationUtils.marshal(key)), handler);
    }

    public void removeIfPresent(K key, V value, Handler<AsyncResult<Boolean>> handler) {
        this.execute(cache -> cache.removeAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler);
    }

    public void replace(K key, V value, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndReplaceAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(value)), handler);
    }

    public void replaceIfPresent(K key, V oldValue, V newValue, Handler<AsyncResult<Boolean>> handler) {
        this.execute(cache -> cache.replaceAsync(ClusterSerializationUtils.marshal(key), ClusterSerializationUtils.marshal(oldValue), ClusterSerializationUtils.marshal(newValue)), handler);
    }

    public void clear(Handler<AsyncResult<Void>> handler) {
        this.execute(IgniteCache::clearAsync, handler);
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        this.execute(rec$ -> ((IgniteCache)rec$).sizeAsync(new CachePeekMode[0]), handler);
    }

    public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        Future entriesFuture = Future.future();
        this.entries((Handler<AsyncResult<Map<K, V>>>)entriesFuture);
        entriesFuture.map(Map::keySet).setHandler(resultHandler);
    }

    public void values(Handler<AsyncResult<List<V>>> resultHandler) {
        Future entriesFuture = Future.future();
        this.entries((Handler<AsyncResult<Map<K, V>>>)entriesFuture);
        entriesFuture.map(map -> new ArrayList(map.values())).setHandler(resultHandler);
    }

    public void entries(Handler<AsyncResult<Map<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            List all = this.cache.query((Query)new ScanQuery()).getAll();
            HashMap<Object, Object> map = new HashMap<Object, Object>(all.size());
            for (Cache.Entry entry : all) {
                map.put(ClusterSerializationUtils.unmarshal(entry.getKey()), ClusterSerializationUtils.unmarshal(entry.getValue()));
            }
            fut.complete(map);
        }, resultHandler);
    }

    private <T> void execute(Function<IgniteCache<K, V>, IgniteFuture<T>> cacheOp, Handler<AsyncResult<T>> handler) {
        this.executeWithTtl(cacheOp, handler, -1L);
    }

    private <T> void executeWithTtl(Function<IgniteCache<K, V>, IgniteFuture<T>> cacheOp, Handler<AsyncResult<T>> handler, long ttl) {
        try {
            IgniteCache cache0 = ttl > 0L ? this.cache.withExpiryPolicy((ExpiryPolicy)new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl))) : this.cache;
            IgniteFuture future = cacheOp.apply(cache0);
            future.listen((IgniteInClosure & Serializable)fut -> this.vertx.executeBlocking(f -> f.complete(ClusterSerializationUtils.unmarshal(future.get())), handler));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

