/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.spi.cluster.ChoosableIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class ChoosableIterableImpl<T>
implements ChoosableIterable<T> {
    private static final ChoosableIterable<Object> EMPTY = new ChoosableIterable<Object>(){

        public boolean isEmpty() {
            return true;
        }

        public Object choose() {
            return null;
        }

        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    };
    private final AtomicReference<List<T>> itemsRef;
    private AtomicInteger chooseCnt = new AtomicInteger();

    public ChoosableIterableImpl(List<T> items) {
        this.itemsRef = new AtomicReference<List<T>>(Objects.requireNonNull(items, "items"));
    }

    public void update(List<T> items) {
        this.itemsRef.set(Objects.requireNonNull(items, "items"));
    }

    public boolean isEmpty() {
        return this.itemsRef.get().isEmpty();
    }

    public Iterator<T> iterator() {
        return this.itemsRef.get().iterator();
    }

    public T choose() {
        List<T> items = this.itemsRef.get();
        if (items.isEmpty()) {
            return null;
        }
        return items.get(Math.abs(this.chooseCnt.getAndIncrement()) % items.size());
    }

    public static <T> ChoosableIterable<T> empty() {
        return EMPTY;
    }
}

