/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.ignite.IgniteCacheOptionsConverter;
import java.util.Map;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.configuration.CacheConfiguration;

@DataObject(generateConverter=true)
public class IgniteCacheOptions {
    private String name;
    private CacheMode cacheMode;
    private int backups;
    private boolean readFromBackup;
    private CacheAtomicityMode atomicityMode;
    private CacheWriteSynchronizationMode writeSynchronizationMode;
    private boolean copyOnRead;
    private boolean eagerTtl;
    private boolean encryptionEnabled;
    private String groupName;
    private boolean invalidate;
    private int maxConcurrentAsyncOperations;
    private boolean onheapCacheEnabled;
    private PartitionLossPolicy partitionLossPolicy;
    private CacheRebalanceMode rebalanceMode;
    private int rebalanceOrder;
    private long rebalanceDelay;
    private int maxQueryInteratorsCount;
    private boolean eventsDisabled;
    private JsonObject expiryPolicy;
    private boolean metricsEnabled;

    public IgniteCacheOptions() {
        this.atomicityMode = CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE;
        this.writeSynchronizationMode = CacheWriteSynchronizationMode.PRIMARY_SYNC;
        this.cacheMode = CacheConfiguration.DFLT_CACHE_MODE;
        this.backups = 0;
        this.readFromBackup = true;
        this.copyOnRead = true;
        this.eagerTtl = true;
        this.invalidate = false;
        this.maxConcurrentAsyncOperations = 500;
        this.partitionLossPolicy = CacheConfiguration.DFLT_PARTITION_LOSS_POLICY;
        this.rebalanceMode = CacheConfiguration.DFLT_REBALANCE_MODE;
        this.maxQueryInteratorsCount = 1024;
        this.eventsDisabled = false;
        this.metricsEnabled = false;
    }

    public IgniteCacheOptions(IgniteCacheOptions options) {
        this.name = options.name;
        this.cacheMode = options.cacheMode;
        this.backups = options.backups;
        this.readFromBackup = options.readFromBackup;
        this.atomicityMode = options.atomicityMode;
        this.writeSynchronizationMode = options.writeSynchronizationMode;
        this.copyOnRead = options.copyOnRead;
        this.eagerTtl = options.eagerTtl;
        this.encryptionEnabled = options.encryptionEnabled;
        this.groupName = options.groupName;
        this.invalidate = options.invalidate;
        this.maxConcurrentAsyncOperations = options.maxConcurrentAsyncOperations;
        this.onheapCacheEnabled = options.onheapCacheEnabled;
        this.partitionLossPolicy = options.partitionLossPolicy;
        this.rebalanceMode = options.rebalanceMode;
        this.rebalanceOrder = options.rebalanceOrder;
        this.rebalanceDelay = options.rebalanceDelay;
        this.maxQueryInteratorsCount = options.maxQueryInteratorsCount;
        this.eventsDisabled = options.eventsDisabled;
        this.expiryPolicy = options.expiryPolicy;
        this.metricsEnabled = options.metricsEnabled;
    }

    public IgniteCacheOptions(JsonObject options) {
        this();
        IgniteCacheOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public String getName() {
        return this.name;
    }

    public IgniteCacheOptions setName(String name) {
        this.name = name;
        return this;
    }

    public String getCacheMode() {
        return this.cacheMode.name();
    }

    public IgniteCacheOptions setCacheMode(String cacheMode) {
        this.cacheMode = CacheMode.valueOf((String)cacheMode);
        return this;
    }

    public int getBackups() {
        return this.backups;
    }

    public IgniteCacheOptions setBackups(int backups) {
        this.backups = backups;
        return this;
    }

    public boolean isReadFromBackup() {
        return this.readFromBackup;
    }

    public IgniteCacheOptions setReadFromBackup(boolean readFromBackup) {
        this.readFromBackup = readFromBackup;
        return this;
    }

    public String getAtomicityMode() {
        return this.atomicityMode.name();
    }

    public IgniteCacheOptions setAtomicityMode(String atomicityMode) {
        this.atomicityMode = CacheAtomicityMode.valueOf((String)atomicityMode);
        return this;
    }

    public String getWriteSynchronizationMode() {
        return this.writeSynchronizationMode.name();
    }

    public IgniteCacheOptions setWriteSynchronizationMode(String writeSynchronizationMode) {
        this.writeSynchronizationMode = CacheWriteSynchronizationMode.valueOf((String)writeSynchronizationMode);
        return this;
    }

    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    public IgniteCacheOptions setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
        return this;
    }

    public boolean isEagerTtl() {
        return this.eagerTtl;
    }

    public IgniteCacheOptions setEagerTtl(boolean eagerTtl) {
        this.eagerTtl = eagerTtl;
        return this;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public IgniteCacheOptions setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public IgniteCacheOptions setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public IgniteCacheOptions setInvalidate(boolean invalidate) {
        this.invalidate = invalidate;
        return this;
    }

    public int getMaxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOperations;
    }

    public IgniteCacheOptions setMaxConcurrentAsyncOperations(int maxConcurrentAsyncOperations) {
        this.maxConcurrentAsyncOperations = maxConcurrentAsyncOperations;
        return this;
    }

    public boolean isOnheapCacheEnabled() {
        return this.onheapCacheEnabled;
    }

    public IgniteCacheOptions setOnheapCacheEnabled(boolean onheapCacheEnabled) {
        this.onheapCacheEnabled = onheapCacheEnabled;
        return this;
    }

    public String getPartitionLossPolicy() {
        return this.partitionLossPolicy.name();
    }

    public IgniteCacheOptions setPartitionLossPolicy(String partitionLossPolicy) {
        this.partitionLossPolicy = PartitionLossPolicy.valueOf((String)partitionLossPolicy);
        return this;
    }

    public String getRebalanceMode() {
        return this.rebalanceMode.name();
    }

    public IgniteCacheOptions setRebalanceMode(String rebalanceMode) {
        this.rebalanceMode = CacheRebalanceMode.valueOf((String)rebalanceMode);
        return this;
    }

    public int getRebalanceOrder() {
        return this.rebalanceOrder;
    }

    public IgniteCacheOptions setRebalanceOrder(int rebalanceOrder) {
        this.rebalanceOrder = rebalanceOrder;
        return this;
    }

    public long getRebalanceDelay() {
        return this.rebalanceDelay;
    }

    public IgniteCacheOptions setRebalanceDelay(long rebalanceDelay) {
        this.rebalanceDelay = rebalanceDelay;
        return this;
    }

    public int getMaxQueryInteratorsCount() {
        return this.maxQueryInteratorsCount;
    }

    public IgniteCacheOptions setMaxQueryInteratorsCount(int maxQueryInteratorsCount) {
        this.maxQueryInteratorsCount = maxQueryInteratorsCount;
        return this;
    }

    public boolean isEventsDisabled() {
        return this.eventsDisabled;
    }

    public IgniteCacheOptions setEventsDisabled(boolean eventsDisabled) {
        this.eventsDisabled = eventsDisabled;
        return this;
    }

    public JsonObject getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public IgniteCacheOptions setExpiryPolicy(JsonObject expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public IgniteCacheOptions setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        IgniteCacheOptionsConverter.toJson(this, json);
        return json;
    }
}

