/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.ignite.IgniteCacheOptions;
import io.vertx.spi.cluster.ignite.IgniteDiscoveryOptions;
import io.vertx.spi.cluster.ignite.IgniteMetricExporterOptions;
import io.vertx.spi.cluster.ignite.IgniteOptionsConverter;
import io.vertx.spi.cluster.ignite.IgniteSslOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;

@DataObject(generateConverter=true)
public class IgniteOptions {
    private String localHost;
    private int localPort;
    private int connectionsPerNode;
    private long connectTimeout;
    private long idleConnectionTimeout;
    private long maxConnectTimeout;
    private int reconnectCount;
    private long metricsLogFrequency;
    private IgniteDiscoveryOptions discoveryOptions;
    private List<IgniteCacheOptions> cacheConfiguration;
    private IgniteSslOptions sslOptions;
    private boolean shutdownOnSegmentation;
    private int pageSize;
    private long defaultRegionInitialSize;
    private long defaultRegionMaxSize;
    private boolean defaultRegionMetricsEnabled;
    private boolean shutdownOnNodeStop;
    private long metricsUpdateFrequency;
    private long clientFailureDetectionTimeout;
    private int metricsHistorySize;
    private long metricsExpireTime;
    private IgniteMetricExporterOptions metricExporterOptions;

    public IgniteOptions() {
        this.localPort = 47100;
        this.connectionsPerNode = 1;
        this.connectTimeout = 5000L;
        this.idleConnectionTimeout = 600000L;
        this.reconnectCount = 10;
        this.maxConnectTimeout = 600000L;
        this.metricsLogFrequency = 60000L;
        this.discoveryOptions = new IgniteDiscoveryOptions();
        this.cacheConfiguration = new ArrayList<IgniteCacheOptions>();
        this.shutdownOnSegmentation = true;
        this.pageSize = 4096;
        this.defaultRegionInitialSize = 0x10000000L;
        this.defaultRegionMaxSize = DataStorageConfiguration.DFLT_DATA_REGION_MAX_SIZE;
        this.defaultRegionMetricsEnabled = false;
        this.shutdownOnNodeStop = false;
        this.metricsUpdateFrequency = 2000L;
        this.clientFailureDetectionTimeout = IgniteConfiguration.DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT;
        this.metricsHistorySize = 10000;
        this.metricsExpireTime = Long.MAX_VALUE;
        this.metricExporterOptions = new IgniteMetricExporterOptions();
    }

    public IgniteOptions(IgniteOptions options) {
        this.localHost = options.localHost;
        this.localPort = options.localPort;
        this.connectionsPerNode = options.connectionsPerNode;
        this.connectTimeout = options.connectTimeout;
        this.idleConnectionTimeout = options.idleConnectionTimeout;
        this.reconnectCount = options.reconnectCount;
        this.maxConnectTimeout = options.maxConnectTimeout;
        this.metricsLogFrequency = options.metricsLogFrequency;
        this.discoveryOptions = options.discoveryOptions;
        this.cacheConfiguration = options.cacheConfiguration;
        this.sslOptions = options.sslOptions;
        this.shutdownOnSegmentation = options.shutdownOnSegmentation;
        this.pageSize = options.pageSize;
        this.defaultRegionInitialSize = options.defaultRegionInitialSize;
        this.defaultRegionMaxSize = options.defaultRegionMaxSize;
        this.defaultRegionMetricsEnabled = options.defaultRegionMetricsEnabled;
        this.shutdownOnNodeStop = options.shutdownOnNodeStop;
        this.metricsUpdateFrequency = options.metricsUpdateFrequency;
        this.clientFailureDetectionTimeout = options.clientFailureDetectionTimeout;
        this.metricsHistorySize = options.metricsHistorySize;
        this.metricsExpireTime = options.metricsExpireTime;
        this.metricExporterOptions = options.metricExporterOptions;
    }

    public IgniteOptions(JsonObject options) {
        this();
        IgniteOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public IgniteOptions setLocalHost(String localHost) {
        this.localHost = localHost;
        return this;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public IgniteOptions setLocalPort(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public int getConnectionsPerNode() {
        return this.connectionsPerNode;
    }

    public IgniteOptions setConnectionsPerNode(int connectionsPerNode) {
        this.connectionsPerNode = connectionsPerNode;
        return this;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public IgniteOptions setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public long getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public IgniteOptions setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public long getMaxConnectTimeout() {
        return this.maxConnectTimeout;
    }

    public IgniteOptions setMaxConnectTimeout(long maxConnectTimeout) {
        this.maxConnectTimeout = maxConnectTimeout;
        return this;
    }

    public int getReconnectCount() {
        return this.reconnectCount;
    }

    public IgniteOptions setReconnectCount(int reconnectCount) {
        this.reconnectCount = reconnectCount;
        return this;
    }

    public long getMetricsLogFrequency() {
        return this.metricsLogFrequency;
    }

    public IgniteOptions setMetricsLogFrequency(long metricsLogFrequency) {
        this.metricsLogFrequency = metricsLogFrequency;
        return this;
    }

    public IgniteDiscoveryOptions getDiscoverySpi() {
        return this.discoveryOptions;
    }

    public IgniteOptions setDiscoverySpi(IgniteDiscoveryOptions discoveryOptions) {
        this.discoveryOptions = discoveryOptions;
        return this;
    }

    public List<IgniteCacheOptions> getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public IgniteOptions setCacheConfiguration(List<IgniteCacheOptions> cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    public IgniteSslOptions getSslContextFactory() {
        return this.sslOptions;
    }

    public IgniteOptions setSslContextFactory(IgniteSslOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public boolean isShutdownOnSegmentation() {
        return this.shutdownOnSegmentation;
    }

    public IgniteOptions setShutdownOnSegmentation(boolean shutdownOnSegmentation) {
        this.shutdownOnSegmentation = shutdownOnSegmentation;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public IgniteOptions setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getDefaultRegionInitialSize() {
        return this.defaultRegionInitialSize;
    }

    public IgniteOptions setDefaultRegionInitialSize(long defaultRegionInitialSize) {
        this.defaultRegionInitialSize = defaultRegionInitialSize;
        return this;
    }

    public long getDefaultRegionMaxSize() {
        return this.defaultRegionMaxSize;
    }

    public IgniteOptions setDefaultRegionMaxSize(long defaultRegionMaxSize) {
        this.defaultRegionMaxSize = defaultRegionMaxSize;
        return this;
    }

    public boolean isDefaultRegionMetricsEnabled() {
        return this.defaultRegionMetricsEnabled;
    }

    public IgniteOptions setDefaultRegionMetricsEnabled(boolean defaultRegionMetricsEnabled) {
        this.defaultRegionMetricsEnabled = defaultRegionMetricsEnabled;
        return this;
    }

    public boolean isShutdownOnNodeStop() {
        return this.shutdownOnNodeStop;
    }

    public IgniteOptions setShutdownOnNodeStop(boolean shutdownOnNodeStop) {
        this.shutdownOnNodeStop = shutdownOnNodeStop;
        return this;
    }

    public long getMetricsUpdateFrequency() {
        return this.metricsUpdateFrequency;
    }

    public IgniteOptions setMetricsUpdateFrequency(long metricsUpdateFrequency) {
        this.metricsUpdateFrequency = metricsUpdateFrequency;
        return this;
    }

    public long getClientFailureDetectionTimeout() {
        return this.clientFailureDetectionTimeout;
    }

    public IgniteOptions setClientFailureDetectionTimeout(long clientFailureDetectionTimeout) {
        this.clientFailureDetectionTimeout = clientFailureDetectionTimeout;
        return this;
    }

    public int getMetricsHistorySize() {
        return this.metricsHistorySize;
    }

    public IgniteOptions setMetricsHistorySize(int metricsHistorySize) {
        this.metricsHistorySize = metricsHistorySize;
        return this;
    }

    public long getMetricsExpireTime() {
        return this.metricsExpireTime;
    }

    public IgniteOptions setMetricsExpireTime(long metricsExpireTime) {
        this.metricsExpireTime = metricsExpireTime;
        return this;
    }

    public IgniteMetricExporterOptions getMetricExporterSpi() {
        return this.metricExporterOptions;
    }

    public IgniteOptions setMetricExporterSpi(IgniteMetricExporterOptions metricExporterOptions) {
        this.metricExporterOptions = metricExporterOptions;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        IgniteOptionsConverter.toJson(this, json);
        return json;
    }
}

