/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.util.GridClassLoaderCache;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.junit.Assert;

public class Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);

    public static void close(List<Vertx> clustered) throws Exception {
        CountDownLatch latch = new CountDownLatch(clustered.size());
        for (Vertx vertx : clustered) {
            Thread.sleep(500L);
            vertx.close().onComplete(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to shutdown vert.x", ar.cause());
                }
                latch.countDown();
            });
        }
        Assert.assertTrue((boolean)latch.await(180L, TimeUnit.SECONDS));
        Thread.sleep(200L);
        ArrayList list = new ArrayList(G.allGrids());
        for (Ignite g : list) {
            Lifecycle.stopGrid(g.name());
        }
        List list2 = G.allGrids();
        assert (list2.isEmpty()) : list2;
        GridClassLoaderCache.clear();
        U.clearClassCache();
        MarshallerExclusions.clearCache();
        BinaryEnumCache.clear();
    }

    private static void stopGrid(String igniteInstanceName) {
        try {
            IgniteEx ignite = (IgniteEx)G.ignite((String)igniteInstanceName);
            assert (ignite != null) : "Ignite returned null grid for name: " + igniteInstanceName;
            UUID id = ignite.context().localNodeId();
            log.info((Object)(">>> Stopping grid [name=" + ignite.name() + ", id=" + id + ']'));
            IgniteUtils.setCurrentIgniteName((String)igniteInstanceName);
            try {
                G.stop((String)igniteInstanceName, (boolean)true);
            }
            finally {
                IgniteUtils.setCurrentIgniteName(null);
            }
        }
        catch (IllegalStateException ignite) {
        }
        catch (Throwable e) {
            log.error((Object)("Failed to stop grid [igniteInstanceName=" + igniteInstanceName + ']'), e);
        }
    }
}

