/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.Lifecycle;
import io.vertx.LoggingTestWatcher;
import io.vertx.core.AsyncResult;
import io.vertx.core.ComplexHATest;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.ignite.IgniteClusterManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class IgniteComplexHATest
extends ComplexHATest {
    @Rule
    public LoggingTestWatcher watchman = new LoggingTestWatcher();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public void setUp() throws Exception {
        System.setProperty("IGNITE_HOME", this.temporaryFolder.newFolder().getAbsolutePath());
        super.setUp();
    }

    protected void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> ar) {
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        super.clusteredVertx(options, ar);
    }

    protected ClusterManager getClusterManager() {
        return new IgniteClusterManager();
    }

    protected void close(List<Vertx> clustered) throws Exception {
        Lifecycle.close(clustered);
    }
}

