/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.LoggingTestWatcher;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.impl.DiscoveryImplTestBase;
import io.vertx.spi.cluster.ignite.IgniteClusterManager;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class IgniteDiscoveryImplClusteredTest
extends DiscoveryImplTestBase {
    @Rule
    public LoggingTestWatcher watchman = new LoggingTestWatcher();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        System.setProperty("IGNITE_HOME", this.temporaryFolder.newFolder().getAbsolutePath());
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)new IgniteClusterManager());
        Vertx.clusteredVertx((VertxOptions)options).onComplete(ar -> {
            this.vertx = (Vertx)ar.result();
        });
        Awaitility.await().until(() -> this.vertx != null);
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }
}

